/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.SynthesizedObjectsManagerInterface;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.yosys.helpers.synthesized.SynthesizedObjectType;
import com.lintyservices.yosys.objects.YosysSynthesizedObject;
import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;

public class VhdlSynthesizedObjectsManager
implements SynthesizedObjectsManagerInterface {
    private final Set<YosysSynthesizedObject> synthesizedObjects;
    private final Set<YosysSynthesizedObject> architectures;
    private final Set<YosysSynthesizedObject> blocks;
    private final Set<YosysSynthesizedObject> entities;
    private final Set<YosysSynthesizedObject> processes;

    public VhdlSynthesizedObjectsManager(Set<YosysSynthesizedObject> synthesizedObjects) {
        this.synthesizedObjects = synthesizedObjects;
        this.architectures = synthesizedObjects.stream().filter(o -> o.type() == SynthesizedObjectType.ARCHITECTURE).collect(Collectors.toSet());
        this.blocks = synthesizedObjects.stream().filter(o -> o.type() == SynthesizedObjectType.BLOCK).collect(Collectors.toSet());
        this.entities = synthesizedObjects.stream().filter(o -> o.type() == SynthesizedObjectType.ENTITY).collect(Collectors.toSet());
        this.processes = synthesizedObjects.stream().filter(o -> o.type() == SynthesizedObjectType.PROCESS).collect(Collectors.toSet());
    }

    public boolean isProcessSynthesized(File file, ProcessStatementTree process) {
        return this.processes.stream().filter(o -> o.belongsToFile(file)).anyMatch(o -> o.location().beginLine() == process.line());
    }

    public boolean isArchitectureSynthesized(File file, ArchitectureBodyTree architecture) {
        return this.architectures.stream().filter(o -> o.belongsToFile(file)).filter(o -> o.shortName().equalsIgnoreCase(architecture.identifier().text())).anyMatch(o -> o.location().beginLine() == architecture.line());
    }

    public boolean isEntitySynthesized(File file, EntityDeclarationTree entity) {
        return this.entities.stream().filter(o -> o.belongsToFile(file)).filter(o -> o.shortName().equalsIgnoreCase(entity.identifier().text())).anyMatch(o -> o.location().beginLine() == entity.line());
    }

    public boolean isBlockSynthesized(File file, VhdlTree block) {
        return this.blocks.stream().filter(o -> o.belongsToFile(file)).anyMatch(o -> o.location().beginLine() == block.line());
    }
}

