/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock;

import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.ClockTransitionType;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.IfElsifConditionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.yosys.helpers.clock.ClockDirection;
import java.io.File;
import javax.annotation.Nullable;

public class ClockUsage {
    private final String name;
    private final GenericTreeFile<VhdlSyntaxToken> treeFile;
    private final VhdlSyntaxToken tree;
    @Nullable
    private ClockDirection edgeTransitionDirection;
    @Nullable
    private ClockTransitionType edgeTransitionType;
    @Nullable
    private IfElsifConditionTree ifElsifConditionTree;

    public ClockUsage(GenericTreeFile<VhdlSyntaxToken> treeFile, ClockDirection edgeTransitionDirection, IfElsifConditionTree ifElsifConditionTree) {
        this.treeFile = treeFile;
        this.tree = (VhdlSyntaxToken)treeFile.tree();
        this.name = ((VhdlSyntaxToken)treeFile.tree()).text();
        this.edgeTransitionDirection = edgeTransitionDirection;
        this.ifElsifConditionTree = ifElsifConditionTree;
        this.edgeTransitionType = this.computeEdgeTransitionType();
    }

    public ClockUsage(GenericTreeFile<VhdlSyntaxToken> treeFile) {
        this.treeFile = treeFile;
        this.tree = (VhdlSyntaxToken)treeFile.tree();
        this.name = ((VhdlSyntaxToken)treeFile.tree()).text();
    }

    public GenericTreeFile<VhdlSyntaxToken> treeFile() {
        return this.treeFile;
    }

    public VhdlTree tree() {
        return (VhdlTree)this.treeFile.tree();
    }

    public File file() {
        return this.treeFile.file();
    }

    @Nullable
    public ClockDirection edgeTransitionDirection() {
        return this.edgeTransitionDirection;
    }

    public ClockTransitionType edgeTransitionType() {
        return this.edgeTransitionType;
    }

    public String name() {
        return this.name;
    }

    public boolean isClockWayUsage() {
        return this.inProcessBody() && this.inIfElsifCondition() || this.inProcessSensitivityList() || this.inComponentInstantiation();
    }

    public boolean isNonClockWayUsage() {
        return !this.isClockWayUsage();
    }

    public boolean isYosysClockUsage() {
        return this.edgeTransitionType != null;
    }

    @Nullable
    public IfElsifConditionTree ifElsifConditionTree() {
        return this.ifElsifConditionTree;
    }

    public boolean inProcessBody() {
        return this.tree.hasAncestor(VhdlTree.Kind.PROCESS_STATEMENT_PART);
    }

    public boolean inProcessSensitivityList() {
        return this.tree.hasAncestor(VhdlTree.Kind.SENSITIVITY_LIST) && this.tree.hasAncestor(VhdlTree.Kind.PROCESS_STATEMENT);
    }

    public boolean inIfElsifCondition() {
        return this.tree.hasAncestor(VhdlTree.Kind.IF_ELSIF_CONDITION);
    }

    @Nullable
    public ProcessStatementTree processTree() {
        if (this.tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT) != null) {
            return (ProcessStatementTree)this.tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT);
        }
        return null;
    }

    private boolean inComponentInstantiation() {
        return this.tree.hasAncestor(VhdlTree.Kind.COMPONENT_INSTANTIATION_STATEMENT);
    }

    @Nullable
    private ClockTransitionType computeEdgeTransitionType() {
        if (this.ifElsifConditionTree != null) {
            String condition = this.ifElsifConditionTree.toString().replaceAll("\\s+", "").toLowerCase().replaceAll(this.name.toLowerCase(), this.name);
            if (condition.contains("rising_edge(" + this.name + ")")) {
                return ClockTransitionType.EDGE;
            }
            if (condition.contains(this.name + "='1'and" + this.name + "'event") || condition.contains(this.name + "'eventand" + this.name + "='1'")) {
                return ClockTransitionType.EVENT;
            }
            if (condition.contains(this.name + "='1'andnot" + this.name + "'stable") || condition.contains("not" + this.name + "'stableand" + this.name + "='1'")) {
                return ClockTransitionType.NOT_STABLE;
            }
            if (condition.contains("falling_edge(" + this.name + ")")) {
                return ClockTransitionType.EDGE;
            }
            if (condition.contains(this.name + "='0'and" + this.name + "'event") || condition.contains(this.name + "'eventand" + this.name + "='0'")) {
                return ClockTransitionType.EVENT;
            }
            if (condition.contains(this.name + "='0'andnot" + this.name + "'stable") || condition.contains("not" + this.name + "'stableand" + this.name + "='0'")) {
                return ClockTransitionType.NOT_STABLE;
            }
        }
        return ClockTransitionType.UNDEFINED;
    }
}

