/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.VhdlSynthesizedObjectsManager;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clock;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.ClockUsage;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.VhdlTreeFileUtils;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfElsifConditionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.helpers.clock.ClockCellType;
import com.lintyservices.yosys.helpers.clock.ClockDirection;
import com.lintyservices.yosys.objects.YosysClockUsage;
import com.lintyservices.yosys.objects.YosysSignal;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clocks
implements ClocksInterface {
    private static final Logger LOG = LoggerFactory.getLogger(Clocks.class);
    private final Set<YosysClockUsage> yosysClockUsage;
    private final Set<EntityTreeFile> entityTreeFiles;
    private final List<ArchitectureTreeFile> architectureTreeFiles;
    private final VhdlSynthesizedObjectsManager synthesizedObjectsManager;
    private final Set<Clock> allClocks;

    public Clocks(Set<YosysClockUsage> yosysClockUsage, Set<EntityTreeFile> entityTreeFiles, Set<ArchitectureTreeFile> architectureTreeFiles, VhdlSynthesizedObjectsManager synthesizedObjectsManager) {
        this.yosysClockUsage = yosysClockUsage;
        this.entityTreeFiles = entityTreeFiles;
        this.architectureTreeFiles = architectureTreeFiles.stream().sorted(new TreeFileComparator()).toList();
        this.synthesizedObjectsManager = synthesizedObjectsManager;
        this.allClocks = this.computeClocks();
    }

    public Set<Clock> clocks() {
        return this.allClocks;
    }

    public boolean isClockedProcess(File file, ProcessStatementTree process) {
        return this.synthesizedObjectsManager.isProcessSynthesized(file, process) && this.allClocks.stream().map(Clock::usage).flatMap(Collection::stream).filter(ClockUsage::isYosysClockUsage).filter(u -> FileUtils.equals(u.file(), file)).filter(u -> u.processTree().line() == process.line()).anyMatch(u -> u.processTree().toString().equals(process.toString()));
    }

    public boolean isCombinationalProcess(File file, ProcessStatementTree process) {
        return this.synthesizedObjectsManager.isProcessSynthesized(file, process) && this.allClocks.stream().map(Clock::usage).flatMap(Collection::stream).filter(ClockUsage::isYosysClockUsage).filter(u -> FileUtils.equals(u.file(), file)).filter(u -> u.processTree().line() == process.line()).noneMatch(u -> u.processTree().toString().equals(process.toString()));
    }

    public Set<ClockUsage> clockUsagePerProcess(File file, ProcessStatementTree process) {
        return this.allClocks.stream().map(Clock::usage).flatMap(Collection::stream).filter(ClockUsage::isYosysClockUsage).filter(u -> FileUtils.equals(u.file(), file)).filter(u -> u.processTree().line() == process.line()).filter(u -> u.processTree().toString().equals(process.toString())).collect(Collectors.toSet());
    }

    public Set<YosysSignal> sourceSignals() {
        return this.yosysClockUsage.stream().map(YosysClockUsage::sourceSignals).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<Object> sourceSignals(Set<YosysClockUsage> clockUsage, Set<EntityTreeFile> entities) {
        HashSet<Object> sourceSignals = new HashSet<Object>();
        for (YosysSignal signal : clockUsage.stream().map(YosysClockUsage::sourceSignals).flatMap(Collection::stream).collect(Collectors.toSet())) {
            GenericTreeFile<IdentifierTree> portLocation = VhdlTreeFileUtils.findPortLocationFromYosysSignal(signal, entities);
            sourceSignals.add(Objects.requireNonNullElseGet(portLocation, () -> signal.name() + "|" + signal.module().name()));
        }
        return sourceSignals;
    }

    private Set<Clock> computeClocks() {
        HashSet<Clock> clocks = new HashSet<Clock>();
        for (Map.Entry<String, Set<YosysClockUsage>> entry : this.allYosysClockUsageByEntityName().entrySet()) {
            String entityName = entry.getKey();
            for (Map.Entry<String, Set<YosysClockUsage>> entityClockUsageByName : this.yosysClockUsageByName(entry.getValue()).entrySet()) {
                EntityTreeFile entityTreeFile;
                String clockName = entityClockUsageByName.getKey();
                GenericTreeFile<IdentifierTree> clockDeclarationAsIdentifierTree = this.getClockDeclarationAsIdentifierTree(clockName, entityTreeFile = VhdlTreeFileUtils.getEntityTreeFile(this.entityTreeFiles, entityName));
                if (clockDeclarationAsIdentifierTree == null) continue;
                Set<ClockDirection> directions = this.getClockDirectionsFromClockUsage(entityClockUsageByName.getValue());
                Set<Set<ClockUsage>> allUsage = this.allUsage(clockName, entityTreeFile, entityClockUsageByName.getValue());
                clocks.add(new Clock(clockDeclarationAsIdentifierTree, entityTreeFile, directions, allUsage, this.sourceSignals(entityClockUsageByName.getValue(), this.entityTreeFiles)));
            }
        }
        return clocks;
    }

    private Set<Set<ClockUsage>> allUsage(String clockName, EntityTreeFile treeFile, Set<YosysClockUsage> yosysClockUsage) {
        HashSet<Set<ClockUsage>> usage = new HashSet<Set<ClockUsage>>();
        Set<Set<ClockUsage>> usageInArchitectures = this.usageInArchitectures(clockName, ((EntityDeclarationTree)treeFile.tree()).identifier().text(), yosysClockUsage);
        Set<ClockUsage> usageInEntity = this.usageInEntity(clockName, treeFile);
        if (!usageInEntity.isEmpty()) {
            usage.add(usageInEntity);
        }
        if (!usageInArchitectures.isEmpty()) {
            usage.addAll(usageInArchitectures);
        }
        return usage;
    }

    private Set<ClockUsage> usageInEntity(String clockName, EntityTreeFile treeFile) {
        return ((EntityDeclarationTree)treeFile.tree()).allChildren(VhdlTree.Kind.TOKEN).stream().map(VhdlSyntaxToken.class::cast).filter(t -> t.text().equals(clockName)).filter(t -> !t.hasAncestor(VhdlTree.Kind.ENTITY_HEADER)).map(t -> new ClockUsage(new GenericTreeFile<VhdlSyntaxToken>((VhdlSyntaxToken)t, treeFile.file()))).collect(Collectors.toSet());
    }

    private Set<Set<ClockUsage>> usageInArchitectures(String clockName, String entityName, Set<YosysClockUsage> yosysClockUsage) {
        HashSet<Set<ClockUsage>> allUsage = new HashSet<Set<ClockUsage>>();
        for (ArchitectureTreeFile architectureTreeFile : VhdlTreeFileUtils.getArchitectureTreeFiles(new HashSet<ArchitectureTreeFile>(this.architectureTreeFiles), entityName)) {
            HashSet<ClockUsage> usageInArchitectureAsClockUsage = new HashSet<ClockUsage>();
            Set usageInArchitectureAsToken = ((ArchitectureBodyTree)architectureTreeFile.tree()).allChildren(VhdlTree.Kind.TOKEN).stream().map(VhdlSyntaxToken.class::cast).filter(t -> t.text().equals(clockName)).filter(t -> !t.hasAncestor(VhdlTree.Kind.ARCHITECTURE_DECLARATIVE_PART)).filter(t -> !t.hasAncestor(VhdlTree.Kind.COMPONENT_INSTANTIATION_STATEMENT) || !t.hasAncestor(VhdlTree.Kind.ASSOCIATION_ELEMENT) || !t.hasAncestor(VhdlTree.Kind.FORMAL_PART)).collect(Collectors.toSet());
            for (VhdlSyntaxToken token : usageInArchitectureAsToken) {
                if (token.hasAncestor(VhdlTree.Kind.IF_ELSIF_CONDITION)) {
                    IfElsifConditionTree flipFlopIfElsifConditionTree = (IfElsifConditionTree)token.ancestor(VhdlTree.Kind.IF_ELSIF_CONDITION);
                    int flipFlopBeginLine = flipFlopIfElsifConditionTree.ancestor(VhdlTree.Kind.IF_STATEMENT).line();
                    int flipFlopEndLine = flipFlopIfElsifConditionTree.ancestor(VhdlTree.Kind.IF_STATEMENT).endLine();
                    YosysClockUsage usageInFlipFlop = yosysClockUsage.stream().filter(c -> c.name().equals(token.text())).filter(c -> c.cellType() == ClockCellType.FLIP_FLOP).filter(c -> c.location() != null).filter(c -> c.location().endLine() == flipFlopEndLine).findFirst().orElse(null);
                    if (usageInFlipFlop != null) {
                        usageInArchitectureAsClockUsage.add(new ClockUsage(new GenericTreeFile<VhdlSyntaxToken>(token, architectureTreeFile.file()), usageInFlipFlop.direction(), flipFlopIfElsifConditionTree));
                        continue;
                    }
                    YosysClockUsage usageInMemoryCell = yosysClockUsage.stream().filter(c -> c.name().equals(token.text())).filter(c -> c.cellType() == ClockCellType.MEMORY).filter(c -> c.location() != null).filter(c -> c.location().endLine() >= flipFlopBeginLine && c.location().endLine() <= flipFlopEndLine).findFirst().orElse(null);
                    if (usageInMemoryCell != null) {
                        usageInArchitectureAsClockUsage.add(new ClockUsage(new GenericTreeFile<VhdlSyntaxToken>(token, architectureTreeFile.file()), usageInMemoryCell.direction(), flipFlopIfElsifConditionTree));
                        continue;
                    }
                    usageInArchitectureAsClockUsage.add(new ClockUsage(new GenericTreeFile<VhdlSyntaxToken>(token, architectureTreeFile.file())));
                    continue;
                }
                usageInArchitectureAsClockUsage.add(new ClockUsage(new GenericTreeFile<VhdlSyntaxToken>(token, architectureTreeFile.file())));
            }
            if (usageInArchitectureAsClockUsage.isEmpty()) continue;
            allUsage.add(usageInArchitectureAsClockUsage);
        }
        return allUsage;
    }

    private Map<String, Set<YosysClockUsage>> allYosysClockUsageByEntityName() {
        return this.yosysClockUsage.stream().collect(Collectors.groupingBy(c -> c.module().name(), Collectors.toSet()));
    }

    private Map<String, Set<YosysClockUsage>> yosysClockUsageByName(Set<YosysClockUsage> yosysClockUsage) {
        return yosysClockUsage.stream().collect(Collectors.groupingBy(YosysClockUsage::name, Collectors.toSet()));
    }

    @Nullable
    private GenericTreeFile<IdentifierTree> getClockDeclarationAsIdentifierTree(String clockName, EntityTreeFile entityTreeFile) {
        GenericTreeFile portIdentifierTreeFile = ((EntityDeclarationTree)entityTreeFile.tree()).allPortIdentifiers().stream().filter(t -> t.text().equalsIgnoreCase(clockName)).map(t -> new GenericTreeFile<IdentifierTree>((IdentifierTree)t, entityTreeFile.file())).findFirst().orElse(null);
        if (portIdentifierTreeFile != null) {
            return portIdentifierTreeFile;
        }
        for (ArchitectureTreeFile architectureTreeFile : this.architectureTreeFiles) {
            if (!((ArchitectureBodyTree)architectureTreeFile.tree()).entityName().text().equals(((EntityDeclarationTree)entityTreeFile.tree()).identifier().text())) continue;
            GenericTreeFile signalDeclarationIdentifierTreeFile = ((ArchitectureBodyTree)architectureTreeFile.tree()).declarativePart().allChildren(VhdlTree.Kind.SIGNAL_DECLARATION).stream().map(SignalDeclarationTree.class::cast).map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).filter(t -> t.text().equalsIgnoreCase(clockName)).map(t -> new GenericTreeFile<IdentifierTree>((IdentifierTree)t, architectureTreeFile.file())).findFirst().orElse(null);
            if (signalDeclarationIdentifierTreeFile == null) continue;
            return signalDeclarationIdentifierTreeFile;
        }
        LOG.debug("[BugFinder] Cannot find clock declaration for:\n  - Clock name: " + clockName + "\n  - Entity name: " + ((EntityDeclarationTree)entityTreeFile.tree()).identifier().text() + "\n  - File path: " + FileUtils.sanitizedPath(entityTreeFile.file().getAbsolutePath()));
        return null;
    }

    private Set<ClockDirection> getClockDirectionsFromClockUsage(Set<YosysClockUsage> yosysClockUsage) {
        return yosysClockUsage.stream().map(YosysClockUsage::direction).collect(Collectors.toSet());
    }
}

