/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable;

import com.lintyservices.sonar.plugins.bugfinder.objects.enable.EnablesInterface;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.SignalDeclaration;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.ComplexEnable;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enable;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.EnableUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.SimpleEnable;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.VhdlTreeFileUtils;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfElsifConditionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.helpers.enable.EnablePolarity;
import com.lintyservices.yosys.objects.YosysEnableUsage;
import com.lintyservices.yosys.objects.YosysSignal;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enables
implements EnablesInterface {
    private static final Logger LOG = LoggerFactory.getLogger(Enables.class);
    private final Set<YosysEnableUsage> yosysEnableUsage;
    private final Set<EntityTreeFile> entityTreeFiles;
    private final List<ArchitectureTreeFile> architectureTreeFiles;
    private final Set<Enable> allEnables;

    public Enables(Set<YosysEnableUsage> yosysEnableUsage, Set<EntityTreeFile> entityTreeFiles, Set<ArchitectureTreeFile> architectureTreeFiles) {
        this.yosysEnableUsage = yosysEnableUsage;
        this.entityTreeFiles = entityTreeFiles;
        this.architectureTreeFiles = architectureTreeFiles.stream().sorted(new TreeFileComparator()).toList();
        this.allEnables = this.computeEnables();
    }

    public Set<SimpleEnable> allSimpleEnables() {
        return this.allEnables.stream().filter(SimpleEnable.class::isInstance).map(SimpleEnable.class::cast).collect(Collectors.toSet());
    }

    public Set<ComplexEnable> allComplexEnables() {
        return this.allEnables.stream().filter(ComplexEnable.class::isInstance).map(ComplexEnable.class::cast).collect(Collectors.toSet());
    }

    public Map<File, Map<ProcessStatementTree, List<EnableUsage>>> allEnableUsagePerFileAndPerProcess() {
        Map<File, List<EnableUsage>> allUsageByFile = this.allSimpleEnables().stream().map(SimpleEnable::usage).flatMap(Collection::stream).filter(EnableUsage::isYosysEnableUsage).collect(Collectors.groupingBy(EnableUsage::file));
        HashMap<File, Map<ProcessStatementTree, List<EnableUsage>>> allUsageByFileAndByProcess = new HashMap<File, Map<ProcessStatementTree, List<EnableUsage>>>();
        for (Map.Entry<File, List<EnableUsage>> entry : allUsageByFile.entrySet()) {
            allUsageByFileAndByProcess.put(entry.getKey(), entry.getValue().stream().collect(Collectors.groupingBy(EnableUsage::processTree)));
        }
        return allUsageByFileAndByProcess;
    }

    public Set<EnableUsage> enableUsagePerProcess(File file, ProcessStatementTree process) {
        return this.allSimpleEnables().stream().map(SimpleEnable::usage).flatMap(Collection::stream).filter(EnableUsage::isYosysEnableUsage).filter(u -> FileUtils.equals(u.file(), file)).filter(u -> u.processTree().line() == process.line()).filter(u -> u.processTree().toString().equals(process.toString())).collect(Collectors.toSet());
    }

    private Set<Enable> computeEnables() {
        HashSet<Enable> enables = new HashSet<Enable>();
        for (Map.Entry<String, Set<YosysEnableUsage>> entry : this.allYosysEnableUsageByEntityName().entrySet()) {
            String entityName = entry.getKey();
            EntityTreeFile entityTreeFile = VhdlTreeFileUtils.getEntityTreeFile(this.entityTreeFiles, entityName);
            for (Map.Entry<String, Set<YosysEnableUsage>> entitySimpleEnableUsageByName : this.simpleYosysEnableUsageByName(entry.getValue()).entrySet()) {
                String enableName = entitySimpleEnableUsageByName.getKey();
                SignalDeclaration enableSignalDeclaration = this.getEnableDeclaration(enableName, entityTreeFile);
                if (enableSignalDeclaration == null) continue;
                Set<EnablePolarity> polarities = this.getEnablePolaritiesFromEnableUsage(entitySimpleEnableUsageByName.getValue());
                Set<Set<EnableUsage>> allUsage = this.allUsage(enableName, entityTreeFile, entitySimpleEnableUsageByName.getValue());
                enables.add(new SimpleEnable(enableSignalDeclaration, polarities, allUsage));
            }
            for (YosysEnableUsage usage : this.complexYosysEnableUsageByName(entry.getValue())) {
                HashSet<SignalDeclaration> enableDeclarations = new HashSet<SignalDeclaration>();
                for (YosysSignal signal : usage.relatedPublicWires()) {
                    String actualName = signal.name().replace("[", ".").replace("]", "");
                    SignalDeclaration enableDeclaration = this.getEnableDeclaration(actualName, entityTreeFile);
                    if (enableDeclaration == null) continue;
                    enableDeclarations.add(enableDeclaration);
                }
                IfStatementTree ifStatementTree = this.complexEnableIfStatement(usage);
                if (ifStatementTree == null) continue;
                enables.add(new ComplexEnable(usage.location().file(), usage.location().endLine(), ifStatementTree, enableDeclarations));
            }
        }
        return enables;
    }

    private Set<Set<EnableUsage>> allUsage(String enableName, EntityTreeFile treeFile, Set<YosysEnableUsage> yosysEnableUsage) {
        HashSet<Set<EnableUsage>> usage = new HashSet<Set<EnableUsage>>();
        Set<Set<EnableUsage>> usageInArchitectures = this.usageInArchitectures(enableName, ((EntityDeclarationTree)treeFile.tree()).identifier().text(), yosysEnableUsage);
        Set<EnableUsage> usageInEntity = this.usageInEntity(enableName, treeFile);
        if (!usageInEntity.isEmpty()) {
            usage.add(usageInEntity);
        }
        if (!usageInArchitectures.isEmpty()) {
            usage.addAll(usageInArchitectures);
        }
        return usage;
    }

    private Set<EnableUsage> usageInEntity(String enableName, EntityTreeFile treeFile) {
        return ((EntityDeclarationTree)treeFile.tree()).allChildren(Set.of(VhdlTree.Kind.IDENTIFIER, VhdlTree.Kind.SELECTED_NAME)).stream().filter(t -> {
            if (t instanceof IdentifierTree) {
                IdentifierTree identifierTree = (IdentifierTree)t;
                return identifierTree.text().equalsIgnoreCase(enableName);
            }
            return ((SelectedNameTree)t).toString().equalsIgnoreCase(enableName);
        }).filter(t -> !t.hasAncestor(VhdlTree.Kind.ENTITY_HEADER)).map(t -> new EnableUsage(new GenericTreeFile<VhdlTree>((VhdlTree)t, treeFile.file()))).collect(Collectors.toSet());
    }

    private Set<Set<EnableUsage>> usageInArchitectures(String enableName, String entityName, Set<YosysEnableUsage> yosysEnableUsage) {
        HashSet<Set<EnableUsage>> allUsage = new HashSet<Set<EnableUsage>>();
        for (ArchitectureTreeFile architectureTreeFile : VhdlTreeFileUtils.getArchitectureTreeFiles(new HashSet<ArchitectureTreeFile>(this.architectureTreeFiles), entityName)) {
            HashSet<EnableUsage> usageInArchitectureAsEnableUsage = new HashSet<EnableUsage>();
            Set usageInArchitectureAsTree = ((ArchitectureBodyTree)architectureTreeFile.tree()).allChildren(Set.of(VhdlTree.Kind.IDENTIFIER, VhdlTree.Kind.SELECTED_NAME)).stream().filter(t -> {
                if (t instanceof IdentifierTree) {
                    IdentifierTree identifierTree = (IdentifierTree)t;
                    return identifierTree.text().equalsIgnoreCase(enableName);
                }
                return ((SelectedNameTree)t).toString().equalsIgnoreCase(enableName);
            }).filter(t -> !t.hasAncestor(VhdlTree.Kind.ARCHITECTURE_DECLARATIVE_PART)).filter(t -> !t.hasAncestor(VhdlTree.Kind.COMPONENT_INSTANTIATION_STATEMENT) || !t.hasAncestor(VhdlTree.Kind.ASSOCIATION_ELEMENT) || !t.hasAncestor(VhdlTree.Kind.FORMAL_PART)).collect(Collectors.toSet());
            for (VhdlTree usageAsTree : usageInArchitectureAsTree) {
                if (usageAsTree.hasAncestor(VhdlTree.Kind.IF_ELSIF_CONDITION)) {
                    IfElsifConditionTree enableElsifCondition = (IfElsifConditionTree)usageAsTree.ancestor(VhdlTree.Kind.IF_ELSIF_CONDITION);
                    VhdlTree flipFlopIfStatement = enableElsifCondition.ancestor(VhdlTree.Kind.IF_STATEMENT).ancestor(VhdlTree.Kind.IF_STATEMENT);
                    if (flipFlopIfStatement == null) continue;
                    YosysEnableUsage usage = yosysEnableUsage.stream().filter(c -> {
                        if (usageAsTree instanceof IdentifierTree) {
                            IdentifierTree identifierTree = (IdentifierTree)usageAsTree;
                            return identifierTree.text().equalsIgnoreCase(c.name());
                        }
                        return usageAsTree.toString().equalsIgnoreCase(c.name());
                    }).filter(c -> c.location() != null && c.location().endLine() <= flipFlopIfStatement.endLine() && c.location().endLine() >= flipFlopIfStatement.line()).findFirst().orElse(null);
                    if (usage != null) {
                        usageInArchitectureAsEnableUsage.add(new EnableUsage(new GenericTreeFile<VhdlTree>(usageAsTree, architectureTreeFile.file()), usage.polarity()));
                        continue;
                    }
                    usageInArchitectureAsEnableUsage.add(new EnableUsage(new GenericTreeFile<VhdlTree>(usageAsTree, architectureTreeFile.file())));
                    continue;
                }
                usageInArchitectureAsEnableUsage.add(new EnableUsage(new GenericTreeFile<VhdlTree>(usageAsTree, architectureTreeFile.file())));
            }
            if (usageInArchitectureAsEnableUsage.isEmpty()) continue;
            allUsage.add(usageInArchitectureAsEnableUsage);
        }
        return allUsage;
    }

    @Nullable
    private IfStatementTree complexEnableIfStatement(YosysEnableUsage enable) {
        Set relatedArchitectureTreeFiles = this.architectureTreeFiles.stream().filter(tf -> enable.belongsToFile(tf.file())).filter(tf -> enable.module().name().equals(((ArchitectureBodyTree)tf.tree()).entityName().text())).collect(Collectors.toSet());
        for (ArchitectureTreeFile architectureTreeFile : relatedArchitectureTreeFiles) {
            GenericTreeFile ifStatementTree = ((ArchitectureBodyTree)architectureTreeFile.tree()).allChildren(VhdlTree.Kind.IF_STATEMENT).stream().filter(t -> t.endLine() == enable.location().endLine()).map(t -> new GenericTreeFile<IfStatementTree>((IfStatementTree)t, architectureTreeFile.file())).findFirst().orElse(null);
            if (ifStatementTree == null) continue;
            return (IfStatementTree)ifStatementTree.tree();
        }
        LOG.debug("[BugFinder] Cannot find if condition for complex enable:\n  - Enable name: " + enable.name() + (String)(enable.location() != null ? "  - Enable file: " + FileUtils.sanitizedPath(enable.location().file().getAbsolutePath()) : "") + (String)(enable.location() != null ? "  - Enable line: " + enable.location().endLine() : "") + "  - Entity name: " + enable.module().name());
        return null;
    }

    private Map<String, Set<YosysEnableUsage>> allYosysEnableUsageByEntityName() {
        return this.yosysEnableUsage.stream().collect(Collectors.groupingBy(c -> c.module().name(), Collectors.toSet()));
    }

    private Map<String, Set<YosysEnableUsage>> simpleYosysEnableUsageByName(Set<YosysEnableUsage> yosysEnableUsage) {
        return yosysEnableUsage.stream().filter(u -> !u.multipleSignalsInvolved()).collect(Collectors.groupingBy(YosysEnableUsage::name, Collectors.toSet()));
    }

    private Set<YosysEnableUsage> complexYosysEnableUsageByName(Set<YosysEnableUsage> yosysEnableUsage) {
        return yosysEnableUsage.stream().filter(YosysEnableUsage::multipleSignalsInvolved).filter(u -> u.location() != null).collect(Collectors.toSet());
    }

    @Nullable
    private SignalDeclaration getEnableDeclaration(String enableName, EntityTreeFile entityTreeFile) {
        String enableShortName = enableName.split("[\\[.]")[0];
        GenericTreeFile portIdentifierTreeFile = ((EntityDeclarationTree)entityTreeFile.tree()).allPortIdentifiers().stream().filter(t -> t.text().equalsIgnoreCase(enableShortName)).map(t -> new GenericTreeFile<IdentifierTree>((IdentifierTree)t, entityTreeFile.file())).findFirst().orElse(null);
        if (portIdentifierTreeFile != null) {
            return new SignalDeclaration(portIdentifierTreeFile, enableName);
        }
        for (ArchitectureTreeFile architectureTreeFile : this.architectureTreeFiles) {
            if (!((ArchitectureBodyTree)architectureTreeFile.tree()).entityName().text().equals(((EntityDeclarationTree)entityTreeFile.tree()).identifier().text())) continue;
            GenericTreeFile signalDeclarationIdentifierTreeFile = ((ArchitectureBodyTree)architectureTreeFile.tree()).declarativePart().allChildren(VhdlTree.Kind.SIGNAL_DECLARATION).stream().map(SignalDeclarationTree.class::cast).map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).filter(t -> t.text().equalsIgnoreCase(enableShortName)).map(t -> new GenericTreeFile<IdentifierTree>((IdentifierTree)t, architectureTreeFile.file())).findFirst().orElse(null);
            if (signalDeclarationIdentifierTreeFile == null) continue;
            return new SignalDeclaration(signalDeclarationIdentifierTreeFile, enableName);
        }
        LOG.debug("[BugFinder] Cannot find enable declaration for:\n  - Enable name: " + enableName + "\n  - Enable short name: " + enableShortName + "\n  - Entity name: " + ((EntityDeclarationTree)entityTreeFile.tree()).identifier().text() + "\n  - File path: " + FileUtils.sanitizedPath(entityTreeFile.file().getAbsolutePath()));
        return null;
    }

    private Set<EnablePolarity> getEnablePolaritiesFromEnableUsage(Set<YosysEnableUsage> yosysEnableUsage) {
        return yosysEnableUsage.stream().map(YosysEnableUsage::polarity).collect(Collectors.toSet());
    }
}

