/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset;

import com.lintyservices.sonar.plugins.bugfinder.objects.reset.ResetsInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.SignalDeclaration;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.ComplexReset;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Reset;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.ResetUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.SimpleReset;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.VhdlTreeFileUtils;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfElsifConditionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.helpers.reset.ResetPolarity;
import com.lintyservices.yosys.helpers.reset.ResetType;
import com.lintyservices.yosys.objects.YosysResetUsage;
import com.lintyservices.yosys.objects.YosysSignal;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resets
implements ResetsInterface {
    private static final Logger LOG = LoggerFactory.getLogger(Resets.class);
    private final Set<YosysResetUsage> yosysResetUsage;
    private final Set<EntityTreeFile> entityTreeFiles;
    private final List<ArchitectureTreeFile> architectureTreeFiles;
    private final Set<Reset> allResets;

    public Resets(Set<YosysResetUsage> yosysResetUsage, Set<EntityTreeFile> entityTreeFiles, Set<ArchitectureTreeFile> architectureTreeFiles) {
        this.yosysResetUsage = yosysResetUsage;
        this.entityTreeFiles = entityTreeFiles;
        this.architectureTreeFiles = architectureTreeFiles.stream().sorted(new TreeFileComparator()).toList();
        this.allResets = this.computeResets();
    }

    public Set<SimpleReset> allSimpleResets() {
        return this.allResets.stream().filter(SimpleReset.class::isInstance).map(SimpleReset.class::cast).collect(Collectors.toSet());
    }

    public Set<ComplexReset> allComplexResets() {
        return this.allResets.stream().filter(ComplexReset.class::isInstance).map(ComplexReset.class::cast).collect(Collectors.toSet());
    }

    public Map<File, Map<ProcessStatementTree, List<ResetUsage>>> allResetUsagePerFileAndPerProcess() {
        Map<File, List<ResetUsage>> allUsageByFile = this.allSimpleResets().stream().map(SimpleReset::usage).flatMap(Collection::stream).filter(ResetUsage::isYosysResetUsage).collect(Collectors.groupingBy(ResetUsage::file));
        HashMap<File, Map<ProcessStatementTree, List<ResetUsage>>> allUsageByFileAndByProcess = new HashMap<File, Map<ProcessStatementTree, List<ResetUsage>>>();
        for (Map.Entry<File, List<ResetUsage>> entry : allUsageByFile.entrySet()) {
            allUsageByFileAndByProcess.put(entry.getKey(), entry.getValue().stream().collect(Collectors.groupingBy(ResetUsage::processTree)));
        }
        return allUsageByFileAndByProcess;
    }

    public Set<ResetUsage> resetUsagePerProcess(File file, ProcessStatementTree process) {
        return this.allSimpleResets().stream().map(SimpleReset::usage).flatMap(Collection::stream).filter(ResetUsage::isYosysResetUsage).filter(u -> FileUtils.equals(u.file(), file)).filter(u -> u.processTree().line() == process.line()).filter(u -> u.processTree().toString().equals(process.toString())).collect(Collectors.toSet());
    }

    public Set<Object> sourceSignals(Set<YosysResetUsage> resetUsage, Set<EntityTreeFile> entities) {
        HashSet<Object> sourceSignals = new HashSet<Object>();
        for (YosysSignal signal : resetUsage.stream().map(YosysResetUsage::sourceSignals).flatMap(Collection::stream).collect(Collectors.toSet())) {
            GenericTreeFile<IdentifierTree> portLocation = VhdlTreeFileUtils.findPortLocationFromYosysSignal(signal, entities);
            sourceSignals.add(Objects.requireNonNullElseGet(portLocation, () -> signal.name() + "|" + signal.module().name()));
        }
        return sourceSignals;
    }

    private Set<Reset> computeResets() {
        HashSet<Reset> resets = new HashSet<Reset>();
        for (Map.Entry<String, Set<YosysResetUsage>> entry : this.allYosysResetUsageByEntityName().entrySet()) {
            String entityName = entry.getKey();
            EntityTreeFile entityTreeFile = VhdlTreeFileUtils.getEntityTreeFile(this.entityTreeFiles, entityName);
            for (Map.Entry<String, Set<YosysResetUsage>> entitySimpleResetUsageByName : this.simpleYosysResetUsageByName(entry.getValue()).entrySet()) {
                String resetName = entitySimpleResetUsageByName.getKey();
                SignalDeclaration resetSignalDeclaration = this.getResetDeclaration(resetName, entityTreeFile);
                if (resetSignalDeclaration == null) continue;
                Set<ResetPolarity> polarities = this.getResetPolaritiesFromResetUsage(entitySimpleResetUsageByName.getValue());
                Set<ResetType> types = this.getResetTypesFromResetUsage(entitySimpleResetUsageByName.getValue());
                Set<Set<ResetUsage>> allUsage = this.allUsage(resetName, entityTreeFile, entitySimpleResetUsageByName.getValue());
                resets.add(new SimpleReset(resetSignalDeclaration, polarities, types, allUsage, this.sourceSignals(entitySimpleResetUsageByName.getValue(), this.entityTreeFiles)));
            }
            for (YosysResetUsage usage : this.complexYosysResetUsageByName(entry.getValue())) {
                HashSet<SignalDeclaration> resetDeclarations = new HashSet<SignalDeclaration>();
                for (YosysSignal signal : usage.relatedPublicWires()) {
                    String actualName = signal.name().replace("[", ".").replace("]", "");
                    SignalDeclaration resetSignalDeclaration = this.getResetDeclaration(actualName, entityTreeFile);
                    if (resetSignalDeclaration == null) continue;
                    resetDeclarations.add(resetSignalDeclaration);
                }
                IfElsifConditionTree ifElsifConditionTree = this.ifElsifConditionTreeForComplexReset(usage);
                if (ifElsifConditionTree == null) continue;
                resets.add(new ComplexReset(usage.location().file(), usage.location().endLine(), usage.type(), ifElsifConditionTree, resetDeclarations));
            }
        }
        return resets;
    }

    private Set<Set<ResetUsage>> allUsage(String resetName, EntityTreeFile treeFile, Set<YosysResetUsage> yosysResetUsage) {
        HashSet<Set<ResetUsage>> usage = new HashSet<Set<ResetUsage>>();
        Set<Set<ResetUsage>> usageInArchitectures = this.usageInArchitectures(resetName, ((EntityDeclarationTree)treeFile.tree()).identifier().text(), yosysResetUsage);
        Set<ResetUsage> usageInEntity = this.usageInEntity(resetName, treeFile);
        if (!usageInEntity.isEmpty()) {
            usage.add(usageInEntity);
        }
        if (!usageInArchitectures.isEmpty()) {
            usage.addAll(usageInArchitectures);
        }
        return usage;
    }

    private Set<ResetUsage> usageInEntity(String resetName, EntityTreeFile treeFile) {
        return ((EntityDeclarationTree)treeFile.tree()).allChildren(Set.of(VhdlTree.Kind.IDENTIFIER, VhdlTree.Kind.SELECTED_NAME)).stream().filter(t -> {
            if (t instanceof IdentifierTree) {
                IdentifierTree identifierTree = (IdentifierTree)t;
                return identifierTree.text().equalsIgnoreCase(resetName);
            }
            return ((SelectedNameTree)t).toString().equalsIgnoreCase(resetName);
        }).filter(t -> !t.hasAncestor(VhdlTree.Kind.ENTITY_HEADER)).map(t -> new ResetUsage(new GenericTreeFile<VhdlTree>((VhdlTree)t, treeFile.file()))).collect(Collectors.toSet());
    }

    private Set<Set<ResetUsage>> usageInArchitectures(String resetName, String entityName, Set<YosysResetUsage> yosysResetUsage) {
        HashSet<Set<ResetUsage>> allUsage = new HashSet<Set<ResetUsage>>();
        for (ArchitectureTreeFile architectureTreeFile : VhdlTreeFileUtils.getArchitectureTreeFiles(new HashSet<ArchitectureTreeFile>(this.architectureTreeFiles), entityName)) {
            HashSet<ResetUsage> usageInArchitectureAsResetUsage = new HashSet<ResetUsage>();
            Set usageInArchitectureAsTree = ((ArchitectureBodyTree)architectureTreeFile.tree()).allChildren(Set.of(VhdlTree.Kind.IDENTIFIER, VhdlTree.Kind.SELECTED_NAME)).stream().filter(t -> {
                if (t instanceof IdentifierTree) {
                    IdentifierTree identifierTree = (IdentifierTree)t;
                    return identifierTree.text().equalsIgnoreCase(resetName);
                }
                return ((SelectedNameTree)t).toString().equalsIgnoreCase(resetName);
            }).filter(t -> !t.hasAncestor(VhdlTree.Kind.ARCHITECTURE_DECLARATIVE_PART)).filter(t -> !t.hasAncestor(VhdlTree.Kind.COMPONENT_INSTANTIATION_STATEMENT) || !t.hasAncestor(VhdlTree.Kind.ASSOCIATION_ELEMENT) || !t.hasAncestor(VhdlTree.Kind.FORMAL_PART)).collect(Collectors.toSet());
            for (VhdlTree usageAsTree : usageInArchitectureAsTree) {
                if (usageAsTree.hasAncestor(VhdlTree.Kind.IF_ELSIF_CONDITION)) {
                    IfElsifConditionTree flipFlopElsifCondition = (IfElsifConditionTree)usageAsTree.ancestor(VhdlTree.Kind.IF_ELSIF_CONDITION);
                    int flipFlopEndLine = flipFlopElsifCondition.ancestor(VhdlTree.Kind.IF_STATEMENT).endLine();
                    YosysResetUsage usage = yosysResetUsage.stream().filter(c -> {
                        if (usageAsTree instanceof IdentifierTree) {
                            IdentifierTree identifierTree = (IdentifierTree)usageAsTree;
                            return identifierTree.text().equalsIgnoreCase(c.name());
                        }
                        return usageAsTree.toString().equalsIgnoreCase(c.name());
                    }).filter(c -> c.type() == ResetType.ASYNCHRONOUS).filter(c -> c.location() != null && c.location().endLine() == flipFlopEndLine).findFirst().orElse(null);
                    if (usage == null) {
                        int ifStatementForSynchronousResetEndLine = -1;
                        if (usageAsTree.hasAncestor(VhdlTree.Kind.IF_STATEMENT)) {
                            VhdlTree flipFlopIfStatement = usageAsTree.ancestor(VhdlTree.Kind.IF_STATEMENT).ancestor(VhdlTree.Kind.IF_STATEMENT);
                            ifStatementForSynchronousResetEndLine = flipFlopIfStatement != null ? flipFlopIfStatement.endLine() : -1;
                        }
                        int finalIfStatementForSynchronousResetEndLine = ifStatementForSynchronousResetEndLine;
                        usage = yosysResetUsage.stream().filter(c -> {
                            if (usageAsTree instanceof IdentifierTree) {
                                IdentifierTree identifierTree = (IdentifierTree)usageAsTree;
                                return identifierTree.text().equalsIgnoreCase(c.name());
                            }
                            return usageAsTree.toString().equalsIgnoreCase(c.name());
                        }).filter(c -> c.type() == ResetType.SYNCHRONOUS).filter(c -> c.location() != null && c.location().endLine() == finalIfStatementForSynchronousResetEndLine).findFirst().orElse(null);
                    }
                    if (usage != null) {
                        usageInArchitectureAsResetUsage.add(new ResetUsage(new GenericTreeFile<VhdlTree>(usageAsTree, architectureTreeFile.file()), usage.polarity(), usage.type()));
                        continue;
                    }
                    usageInArchitectureAsResetUsage.add(new ResetUsage(new GenericTreeFile<VhdlTree>(usageAsTree, architectureTreeFile.file())));
                    continue;
                }
                usageInArchitectureAsResetUsage.add(new ResetUsage(new GenericTreeFile<VhdlTree>(usageAsTree, architectureTreeFile.file())));
            }
            if (usageInArchitectureAsResetUsage.isEmpty()) continue;
            allUsage.add(usageInArchitectureAsResetUsage);
        }
        return allUsage;
    }

    @Nullable
    private IfElsifConditionTree ifElsifConditionTreeForComplexReset(YosysResetUsage reset) {
        Set relatedArchitectureTreeFiles = this.architectureTreeFiles.stream().filter(tf -> reset.belongsToFile(tf.file())).filter(tf -> reset.module().name().equals(((ArchitectureBodyTree)tf.tree()).entityName().text())).collect(Collectors.toSet());
        for (ArchitectureTreeFile architectureTreeFile : relatedArchitectureTreeFiles) {
            GenericTreeFile ifStatementTree = ((ArchitectureBodyTree)architectureTreeFile.tree()).allChildren(VhdlTree.Kind.IF_STATEMENT).stream().filter(t -> t.endLine() == reset.location().endLine()).map(t -> new GenericTreeFile<IfStatementTree>((IfStatementTree)t, architectureTreeFile.file())).findFirst().orElse(null);
            if (ifStatementTree == null) continue;
            if (reset.type() == ResetType.ASYNCHRONOUS) {
                IfElsifConditionTree ifElsifConditionTree = ((IfStatementTree)ifStatementTree.tree()).allChildren(VhdlTree.Kind.IF_ELSIF_CONDITION).stream().map(IfElsifConditionTree.class::cast).min(Comparator.comparingInt(Tree::line)).orElse(null);
                if (ifElsifConditionTree != null) {
                    return ifElsifConditionTree;
                }
                LOG.debug("[BugFinder] Cannot find asynchronous reset if condition for:\n  - Reset name: " + reset.name() + "\n  - Architecture name: " + ((ArchitectureBodyTree)architectureTreeFile.tree()).identifier().text() + "\n  - File path: " + FileUtils.sanitizedPath(architectureTreeFile.file().getAbsolutePath()));
                return null;
            }
            IfStatementTree resetIfStatementTree = ((IfStatementTree)ifStatementTree.tree()).allChildren(VhdlTree.Kind.IF_STATEMENT).stream().map(IfStatementTree.class::cast).min(Comparator.comparingInt(Tree::line)).orElse(null);
            if (resetIfStatementTree != null) {
                return resetIfStatementTree.condition();
            }
            LOG.debug("[BugFinder] Cannot find synchronous reset if condition for:\n  - Reset name: " + reset.name() + "\n  - Architecture name: " + ((ArchitectureBodyTree)architectureTreeFile.tree()).identifier().text() + "\n  - File path: " + FileUtils.sanitizedPath(architectureTreeFile.file().getAbsolutePath()));
            return null;
        }
        LOG.debug("[BugFinder] Cannot find reset if condition for:\n  - Reset name: " + reset.name() + (String)(reset.location() != null ? "  - Reset file: " + FileUtils.sanitizedPath(reset.location().file().getAbsolutePath()) : "") + (String)(reset.location() != null ? "  - Reset line: " + reset.location().endLine() : "") + "  - Entity name: " + reset.module().name());
        return null;
    }

    private Map<String, Set<YosysResetUsage>> allYosysResetUsageByEntityName() {
        return this.yosysResetUsage.stream().collect(Collectors.groupingBy(c -> c.module().name(), Collectors.toSet()));
    }

    private Map<String, Set<YosysResetUsage>> simpleYosysResetUsageByName(Set<YosysResetUsage> yosysResetUsage) {
        return yosysResetUsage.stream().filter(u -> !u.multipleSignalsInvolved()).collect(Collectors.groupingBy(YosysResetUsage::name, Collectors.toSet()));
    }

    private Set<YosysResetUsage> complexYosysResetUsageByName(Set<YosysResetUsage> yosysResetUsage) {
        return yosysResetUsage.stream().filter(YosysResetUsage::multipleSignalsInvolved).filter(u -> u.location() != null).collect(Collectors.toSet());
    }

    @Nullable
    private SignalDeclaration getResetDeclaration(String resetName, EntityTreeFile entityTreeFile) {
        String resetShortName = resetName.split("[\\[.]")[0];
        GenericTreeFile portIdentifierTreeFile = ((EntityDeclarationTree)entityTreeFile.tree()).allPortIdentifiers().stream().filter(t -> t.text().equalsIgnoreCase(resetShortName)).map(t -> new GenericTreeFile<IdentifierTree>((IdentifierTree)t, entityTreeFile.file())).findFirst().orElse(null);
        if (portIdentifierTreeFile != null) {
            return new SignalDeclaration(portIdentifierTreeFile, resetName);
        }
        for (ArchitectureTreeFile architectureTreeFile : this.architectureTreeFiles) {
            if (!((ArchitectureBodyTree)architectureTreeFile.tree()).entityName().text().equals(((EntityDeclarationTree)entityTreeFile.tree()).identifier().text())) continue;
            GenericTreeFile signalDeclarationIdentifierTreeFile = ((ArchitectureBodyTree)architectureTreeFile.tree()).declarativePart().allChildren(VhdlTree.Kind.SIGNAL_DECLARATION).stream().map(SignalDeclarationTree.class::cast).map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).filter(t -> t.text().equalsIgnoreCase(resetShortName)).map(t -> new GenericTreeFile<IdentifierTree>((IdentifierTree)t, architectureTreeFile.file())).findFirst().orElse(null);
            if (signalDeclarationIdentifierTreeFile == null) continue;
            return new SignalDeclaration(signalDeclarationIdentifierTreeFile, resetName);
        }
        LOG.debug("[BugFinder] Cannot find reset declaration for:\n  - Reset name: " + resetName + "\n  - Reset short name: " + resetShortName + "\n  - Entity name: " + ((EntityDeclarationTree)entityTreeFile.tree()).identifier().text() + "\n  - File path: " + FileUtils.sanitizedPath(entityTreeFile.file().getAbsolutePath()));
        return null;
    }

    private Set<ResetPolarity> getResetPolaritiesFromResetUsage(Set<YosysResetUsage> yosysResetUsage) {
        return yosysResetUsage.stream().map(YosysResetUsage::polarity).collect(Collectors.toSet());
    }

    private Set<ResetType> getResetTypesFromResetUsage(Set<YosysResetUsage> yosysResetUsage) {
        return yosysResetUsage.stream().map(YosysResetUsage::type).collect(Collectors.toSet());
    }
}

