/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.SignalDeclaration;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Reset;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.ResetUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.ResetUsageComparator;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.yosys.helpers.reset.ResetPolarity;
import com.lintyservices.yosys.helpers.reset.ResetType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleReset
implements Reset {
    private final SignalDeclaration signalDeclaration;
    private final Set<ResetPolarity> polarities;
    private final Set<ResetType> types;
    private final Set<Set<ResetUsage>> usage;
    private final List<List<? extends IssueLocationInterface>> usageAsFlows;
    private final Set<Object> sourceSignals;

    public SimpleReset(SignalDeclaration signalDeclaration, Set<ResetPolarity> polarities, Set<ResetType> types, Set<Set<ResetUsage>> usage, Set<Object> sourceSignals) {
        this.signalDeclaration = signalDeclaration;
        this.polarities = polarities;
        this.types = types;
        this.usage = usage;
        this.sourceSignals = sourceSignals;
        this.usageAsFlows = this.usageAsFlows(usage);
        usage.stream().flatMap(Collection::stream).forEach(u -> u.setParent(this));
    }

    public SignalDeclaration signalDeclaration() {
        return this.signalDeclaration;
    }

    public GenericTreeFile<IdentifierTree> treeFile() {
        return this.signalDeclaration.treeFile();
    }

    public String name() {
        return this.signalDeclaration.fullName();
    }

    public VhdlTree tree() {
        return (VhdlTree)this.signalDeclaration.treeFile().tree();
    }

    public File file() {
        return this.signalDeclaration.treeFile().file();
    }

    public Set<ResetPolarity> polarities() {
        return this.polarities;
    }

    public Set<ResetType> types() {
        return this.types;
    }

    public Set<ResetUsage> usage() {
        return this.usage.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean hasActiveHighPolarity() {
        return this.polarities.contains((Object)ResetPolarity.ACTIVE_HIGH);
    }

    public boolean hasActiveLowPolarity() {
        return this.polarities.contains((Object)ResetPolarity.ACTIVE_LOW);
    }

    public boolean hasBothPolarities() {
        return this.polarities.contains((Object)ResetPolarity.ACTIVE_HIGH) && this.polarities.contains((Object)ResetPolarity.ACTIVE_LOW);
    }

    public boolean hasSynchronousType() {
        return this.types.contains((Object)ResetType.SYNCHRONOUS);
    }

    public boolean hasAsynchronousType() {
        return this.types.contains((Object)ResetType.ASYNCHRONOUS);
    }

    public boolean hasBothTypes() {
        return this.types.contains((Object)ResetType.ASYNCHRONOUS) && this.types.contains((Object)ResetType.SYNCHRONOUS);
    }

    public Set<Object> sourceSignals() {
        return this.sourceSignals;
    }

    public List<List<? extends IssueLocationInterface>> usageAsFlows() {
        return this.usageAsFlows;
    }

    private List<List<? extends IssueLocationInterface>> usageAsFlows(Set<Set<ResetUsage>> allUsage) {
        ArrayList<List<? extends IssueLocationInterface>> allIssueLocations = new ArrayList<List<? extends IssueLocationInterface>>();
        ArrayList<HdlIssueLocation> sourceSignalLocations = new ArrayList<HdlIssueLocation>();
        for (Object object : this.sourceSignals) {
            if (object instanceof TreeFile) {
                GenericTreeFile t = (GenericTreeFile)object;
                sourceSignalLocations.add(new HdlIssueLocation(t.file(), (Tree)t.tree(), "Source signal"));
                continue;
            }
            if (!(object instanceof String)) continue;
            String s = (String)object;
            String[] splitSourceSignal = s.split("\\|");
            sourceSignalLocations.add(new HdlIssueLocation(this.file(), this.tree(), "Source signal (unavailable in source code): " + splitSourceSignal[0] + " (module: " + splitSourceSignal[1] + ")"));
        }
        allIssueLocations.add(sourceSignalLocations);
        for (Set set : allUsage) {
            List<HdlIssueLocation> issueLocations = set.stream().sorted(new ResetUsageComparator()).map(u -> {
                Object message = "Usage";
                if (u.polarity() != null && u.type() != null) {
                    message = (String)message + " (" + u.type().value() + " / " + u.polarity().value() + ")";
                } else if (u.polarity() == null && u.type() != null) {
                    message = (String)message + " (" + u.type().value() + ")";
                } else if (u.polarity() != null && u.type() == null) {
                    message = (String)message + " (" + u.polarity().value() + ")";
                }
                return new HdlIssueLocation(u.file(), u.tree(), (String)message);
            }).sorted(Comparator.reverseOrder()).toList();
            allIssueLocations.add(issueLocations);
        }
        return allIssueLocations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleReset)) {
            return false;
        }
        SimpleReset r = (SimpleReset)o;
        return r.signalDeclaration().equals(this.signalDeclaration) && r.polarities().equals(this.polarities) && r.types().equals(this.types);
    }

    public int hashCode() {
        int result = 0;
        for (ResetPolarity polarity : this.polarities) {
            result ^= polarity.hashCode();
        }
        for (ResetType type : this.types) {
            result ^= type.hashCode();
        }
        result *= 31;
        result = 31 * result + this.signalDeclaration.hashCode();
        return result;
    }
}

