/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.treefile;

import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysSignal;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VhdlTreeFileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VhdlTreeFileUtils.class);

    private VhdlTreeFileUtils() {
    }

    public static EntityTreeFile getEntityTreeFile(Set<EntityTreeFile> entityTreeFiles, String entityName) {
        EntityTreeFile entityTreeFile = entityTreeFiles.stream().sorted(new TreeFileComparator()).toList().stream().filter(tf -> ((EntityDeclarationTree)tf.tree()).identifier().text().equals(entityName)).findFirst().orElse(null);
        if (entityTreeFile != null) {
            return entityTreeFile;
        }
        throw new LintyException("Cannot find EntityTreeFile for entity name = " + entityName);
    }

    public static Set<ArchitectureTreeFile> getArchitectureTreeFiles(Set<ArchitectureTreeFile> architectureTreeFiles, String entityName) {
        return architectureTreeFiles.stream().filter(tf -> ((ArchitectureBodyTree)tf.tree()).entityName().text().equals(entityName)).collect(Collectors.toSet());
    }

    @Nullable
    public static GenericTreeFile<IdentifierTree> findPortLocationFromYosysSignal(YosysSignal signal, Set<EntityTreeFile> entities) {
        for (EntityTreeFile entity : entities) {
            IdentifierTree port;
            if (!signal.module().name().equalsIgnoreCase(((EntityDeclarationTree)entity.tree()).identifier().text()) || signal.location() == null || !FileUtils.equals(signal.location().file(), entity.file()) || (port = (IdentifierTree)((EntityDeclarationTree)entity.tree()).allPortIdentifiers().stream().filter(p -> p.text().equals(signal.shortName())).findFirst().orElse(null)) == null) continue;
            return new GenericTreeFile<IdentifierTree>(port, entity.file());
        }
        LOG.debug("Cannot find port from Yosys signal:\n  - name: " + signal.name() + "\n" + (String)(signal.location() != null ? "  - file: " + FileUtils.sanitizedPath(signal.location().file().getAbsolutePath()) + "\n" : "") + (String)(signal.location() != null ? "  - line: " + signal.location().beginLine() + "\n" : ""));
        return null;
    }

    @Nullable
    public static String getArchitectureName(YosysLocation location, Set<ArchitectureTreeFile> architectureTreeFiles) {
        String name = null;
        for (ArchitectureTreeFile architectureTreeFile : architectureTreeFiles) {
            if (!FileUtils.equals(architectureTreeFile.file(), location.file()) || ((ArchitectureBodyTree)architectureTreeFile.tree()).identifier().line() != location.beginLine() || ((ArchitectureBodyTree)architectureTreeFile.tree()).identifier().column() != location.beginColumn() - 1) continue;
            name = ((ArchitectureBodyTree)architectureTreeFile.tree()).identifier().text();
            break;
        }
        return name;
    }
}

