/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clock;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import java.text.MessageFormat;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL1009")
public class ClockNamingConventionCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderClocksAwareVisitor {
    private static final String DEFAULT_FORMAT = "^([a-z\\d_]+_clk)|clk$";
    private Set<Clock> clocks;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^([a-z\\d_]+_clk)|clk$")
    public String format = "^([a-z\\d_]+_clk)|clk$";

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = ((Clocks)clocks).clocks();
    }

    @Override
    public final void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (Clock clock : this.clocks) {
            if (pattern.matcher(clock.name()).matches()) continue;
            this.issues().addPreciseIssueWithFlows(clock.file(), clock.tree(), MessageFormat.format("Rename this clock signal to match the following regular expression: {0}", this.format), clock.usageAsFlows());
        }
    }
}

