/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.vhdl.checks.helpers.VhdlCrossFileVerificLogCheck;
import com.lintyservices.yosys.objects.VerificLogItem;
import org.sonar.check.Rule;

@Rule(key="VHDL1072")
public class CompleteProcessSensitivityListCheck
extends VhdlCrossFileVerificLogCheck {
    @Override
    public final void retrieveIssues() {
        for (VerificLogItem item : this.filteredItems("VHDL-1251")) {
            String message;
            if (item.message().contains("' should be on the sensitivity list of the process") && item.message().split("'").length >= 3) {
                message = String.format("Add '%s' to the sensitivity list of the process.", item.message().split("'")[1].trim());
            } else {
                message = item.message();
                this.logMessageCannotBeCustomized("VHDL1072", item);
            }
            this.issues().addPreciseIssue(item.location(), message);
        }
    }
}

