/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.enable.EnablesInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderEnablesAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.ComplexEnable;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enables;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.SimpleEnable;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.yosys.helpers.enable.EnablePolarity;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1041")
public class EnableUsageCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderEnablesAwareVisitor {
    private Set<SimpleEnable> simpleEnables;
    private Set<ComplexEnable> complexEnables;

    @Override
    public void setEnables(EnablesInterface enables) {
        this.simpleEnables = ((Enables)enables).allSimpleEnables();
        this.complexEnables = ((Enables)enables).allComplexEnables();
    }

    @Override
    public final void retrieveIssues() {
        for (SimpleEnable simpleEnable : this.simpleEnables) {
            String message = "Enable signal: " + simpleEnable.name() + ", polarity(ies): " + simpleEnable.polarities().stream().map(EnablePolarity::value).collect(Collectors.joining(", "));
            this.issues().addPreciseIssueWithFlows(simpleEnable.file(), simpleEnable.tree(), message, simpleEnable.usageAsFlows());
        }
        for (ComplexEnable complexEnable : this.complexEnables) {
            this.issues().addPreciseIssue(complexEnable.file(), complexEnable.flipFlopIfStatement().ifKeyword(), "This flip-flop defines a complex enable involving " + complexEnable.signalDeclarations().size() + " signal" + (complexEnable.signalDeclarations().size() > 1 ? "s" : "") + ".", complexEnable.signalDeclarations().stream().map(s -> new HdlIssueLocation(s.file(), s.tree(), s.fullName())).toList());
        }
    }
}

