/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.objects.reset.ResetsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.ClockUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.ResetUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Resets;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.VhdlBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.yosys.helpers.reset.ResetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1037")
public class MinimalProcessSensitivityListCheck
extends VhdlBugFinderCheck
implements BugFinderClocksAwareVisitor,
BugFinderResetsAwareVisitor {
    private Clocks clocks;
    private Resets resets;

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = (Clocks)clocks;
    }

    @Override
    public void setResets(ResetsInterface resets) {
        this.resets = (Resets)resets;
    }

    @Override
    public void visitProcessStatement(ProcessStatementTree tree) {
        if (tree.hasAllAsSensitivity()) {
            return;
        }
        Set<String> actualSignalNamesInSensitivityList = this.signalNamesInSensitivityList(tree);
        Set<ClockUsage> clockUsage = this.clocks.clockUsagePerProcess(this.context().file(), tree);
        Set<ResetUsage> resetUsage = this.resets.resetUsagePerProcess(this.context().file(), tree);
        Set asyncResets = resetUsage.stream().filter(u -> u.type() == ResetType.ASYNCHRONOUS).collect(Collectors.toSet());
        Set syncResets = resetUsage.stream().filter(u -> u.type() == ResetType.SYNCHRONOUS).collect(Collectors.toSet());
        VhdlTree processIssueTree = tree.sensitivity() != null ? tree.sensitivity() : tree.beginStatementKeyword();
        for (ResetUsage reset : syncResets) {
            if (!actualSignalNamesInSensitivityList.contains(reset.name().toLowerCase())) continue;
            this.addPreciseIssue((VhdlTree)reset.treeFile().tree(), "Remove this synchronous reset signal from the sensitivity list of the process.", List.of(new HdlIssueLocation(processIssueTree, "Process sensitivity list")));
        }
        for (ResetUsage reset : asyncResets) {
            if (actualSignalNamesInSensitivityList.contains(reset.name().toLowerCase())) continue;
            this.addPreciseIssue((VhdlTree)reset.treeFile().tree(), "Add this asynchronous reset signal to the sensitivity list of the process.", List.of(new HdlIssueLocation(processIssueTree, "Process sensitivity list")));
        }
        for (ClockUsage clock : clockUsage) {
            if (actualSignalNamesInSensitivityList.contains(clock.name().toLowerCase())) continue;
            this.addPreciseIssue((VhdlTree)clock.treeFile().tree(), "Add this clock signal to the sensitivity list of the process.", List.of(new HdlIssueLocation(processIssueTree, "Process sensitivity list")));
        }
        this.checkForDuplicates(tree);
        super.visitProcessStatement(tree);
    }

    private Set<String> signalNamesInSensitivityList(ProcessStatementTree tree) {
        if (tree.sensitivity() != null) {
            return tree.sensitivity().nameList().stream().map(n -> n.firstToken().text().toLowerCase()).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private void checkForDuplicates(ProcessStatementTree tree) {
        if (tree.sensitivity() == null) {
            return;
        }
        HashMap frequencyMap = new HashMap();
        for (VhdlSyntaxToken vhdlSyntaxToken : tree.sensitivity().nameList().stream().map(VhdlTree::firstToken).toList()) {
            if (frequencyMap.containsKey(vhdlSyntaxToken.text().toLowerCase())) {
                ((List)frequencyMap.get(vhdlSyntaxToken.text().toLowerCase())).add(vhdlSyntaxToken);
                continue;
            }
            ArrayList<VhdlSyntaxToken> tokenAsList = new ArrayList<VhdlSyntaxToken>();
            tokenAsList.add(vhdlSyntaxToken);
            frequencyMap.put(vhdlSyntaxToken.text().toLowerCase(), tokenAsList);
        }
        for (Map.Entry entry : frequencyMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            this.addPreciseIssue((VhdlTree)((List)entry.getValue()).get(0), "Remove duplicated entry from this sensitivity list.", ((List)entry.getValue()).stream().filter(t -> t != ((List)entry.getValue()).get(0)).map(t -> new HdlIssueLocation((Tree)t, "Duplicated entry")).toList());
        }
    }
}

