/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.enable.EnablesInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderEnablesAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.SignalDeclaration;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.ComplexEnable;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enables;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import java.util.Comparator;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VHDL1047")
public class MultiSignalEnableCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderEnablesAwareVisitor {
    private Set<ComplexEnable> enables;

    @Override
    public void setEnables(EnablesInterface enables) {
        this.enables = ((Enables)enables).allComplexEnables();
    }

    @Override
    public final void retrieveIssues() {
        for (ComplexEnable enable : this.enables) {
            this.issues().addPreciseIssue(enable.file(), enable.flipFlopIfStatement().ifKeyword(), "Remove this complex enable involving " + enable.signalDeclarations().size() + " signals.", enable.signalDeclarations().stream().sorted(Comparator.comparing(SignalDeclaration::treeFile, new TreeFileComparator())).map(s -> new HdlIssueLocation(s.file(), s.tree(), s.fullName())).toList());
        }
    }
}

