/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.enable.EnablesInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderEnablesAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enables;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.SimpleEnable;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1045")
public class MultipleEnablePolaritiesCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderEnablesAwareVisitor {
    private Set<SimpleEnable> enables;

    @Override
    public void setEnables(EnablesInterface enables) {
        this.enables = ((Enables)enables).allSimpleEnables().stream().filter(SimpleEnable::hasBothPolarities).collect(Collectors.toSet());
    }

    @Override
    public final void retrieveIssues() {
        for (SimpleEnable enable : this.enables) {
            this.issues().addPreciseIssueWithFlows(enable.file(), enable.tree(), "Do not mix active-low and active-high enables for the same enable signal.", enable.usageAsFlows());
        }
    }
}

