/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssue;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clock;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.ClockUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1012")
public class NonClockUsageCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderClocksAwareVisitor {
    private Set<Clock> clocks;

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = ((Clocks)clocks).clocks();
    }

    @Override
    public final void retrieveIssues() {
        for (Clock clock : this.clocks) {
            this.issues().addPreciseIssues(clock.usage().stream().filter(usage -> ((VhdlInternalSyntaxToken)usage.tree().firstToken()).isSynthesized()).filter(ClockUsage::isNonClockWayUsage).map(u -> new PreciseIssue(this, new HdlIssueLocation(u.file(), u.tree(), String.format("Remove this usage of the '%s' clock signal.", clock.name())), List.of(new HdlIssueLocation(clock.file(), clock.tree(), "Clock signal")))).collect(Collectors.toSet()));
        }
    }
}

