/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.reset.ResetsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssue;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.ResetUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Resets;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.SimpleReset;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1033")
public class NonResetUsageCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderResetsAwareVisitor {
    private Set<SimpleReset> resets;

    @Override
    public void setResets(ResetsInterface resets) {
        this.resets = ((Resets)resets).allSimpleResets();
    }

    @Override
    public final void retrieveIssues() {
        for (SimpleReset reset : this.resets) {
            this.issues().addPreciseIssues(reset.usage().stream().filter(usage -> ((VhdlInternalSyntaxToken)usage.tree().firstToken()).isSynthesized()).filter(ResetUsage::isNonResetWayUsage).map(u -> new PreciseIssue(this, new HdlIssueLocation(u.file(), u.tree(), String.format("Review this usage of the '%s' reset signal.", reset.name())), List.of(new HdlIssueLocation(reset.file(), reset.tree(), "Reset signal")))).collect(Collectors.toSet()));
        }
    }
}

