/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clock;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL1061")
public class PreserveClockNamesCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderClocksAwareVisitor {
    private static final String DEFAULT_PREFIX_TO_IGNORE = "";
    private static final String DEFAULT_SUFFIX_TO_IGNORE = "";
    private Clocks clocks;
    @RuleProperty(key="prefixToIgnore", description="Regular expression for prefix to remove for signal name comparison (without '^' or '$').\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="")
    public String prefixToIgnore = "";
    @RuleProperty(key="suffixToIgnore", description="Regular expression for suffix to remove for signal name comparison (without '^' or '$').\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="")
    public String suffixToIgnore = "";

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = (Clocks)clocks;
    }

    @Override
    public final void retrieveIssues() {
        for (Clock clock : this.clocks.clocks()) {
            for (Object sourceSignal : clock.sourceSignals()) {
                String processedClockName;
                String sourceSignalName = this.sourceSignalName(sourceSignal);
                String processedSourceSignalName = this.processedSourceSignalName(sourceSignal);
                if (processedSourceSignalName.equals(processedClockName = this.processedName(clock.name()))) continue;
                this.issues().addPreciseIssue(clock.file(), clock.tree(), String.format("Rename this clock signal to preserve its name across the design. Source signal name: %s.", sourceSignalName), List.of(this.secondaryLocations(sourceSignal, clock)));
            }
        }
    }

    private String sourceSignalName(Object sourceSignal) {
        if (sourceSignal instanceof TreeFile) {
            return this.processedName(((IdentifierTree)((GenericTreeFile)sourceSignal).tree()).text());
        }
        return this.processedName(((String)sourceSignal).split("\\|")[0]);
    }

    private String processedSourceSignalName(Object sourceSignal) {
        return this.processedName(this.sourceSignalName(sourceSignal));
    }

    private String processedName(String name) {
        return name.replaceFirst("^" + this.prefixToIgnore, "").replaceFirst(this.suffixToIgnore + "$", "");
    }

    private HdlIssueLocation secondaryLocations(Object sourceSignal, Clock clock) {
        if (sourceSignal instanceof TreeFile) {
            TreeFile s = (TreeFile)sourceSignal;
            return new HdlIssueLocation(s.file(), (Tree)s.tree(), "Source signal");
        }
        String[] splitSourceSignal = ((String)sourceSignal).split("\\|");
        return new HdlIssueLocation(clock.file(), clock.tree(), String.format("Source signal (unavailable in source code): %s (module: %s)", splitSourceSignal[0], splitSourceSignal[1]));
    }
}

