/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.reset.ResetsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Resets;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.SimpleReset;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL1062")
public class PreserveResetNamesCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderResetsAwareVisitor {
    private static final String DEFAULT_PREFIX_TO_IGNORE = "";
    private static final String DEFAULT_SUFFIX_TO_IGNORE = "";
    private Resets resets;
    @RuleProperty(key="prefixToIgnore", description="Regular expression for prefix to remove for signal name comparison (without '^' or '$').\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="")
    public String prefixToIgnore = "";
    @RuleProperty(key="suffixToIgnore", description="Regular expression for suffix to remove for signal name comparison (without '^' or '$').\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="")
    public String suffixToIgnore = "";

    @Override
    public void setResets(ResetsInterface resets) {
        this.resets = (Resets)resets;
    }

    @Override
    public final void retrieveIssues() {
        for (SimpleReset reset : this.resets.allSimpleResets()) {
            for (Object sourceSignal : reset.sourceSignals()) {
                String processedResetName;
                String sourceSignalName = this.sourceSignalName(sourceSignal);
                String processedSourceSignalName = this.processedSourceSignalName(sourceSignal);
                if (processedSourceSignalName.equals(processedResetName = this.processedName(reset.signalDeclaration().farLeftName()))) continue;
                this.issues().addPreciseIssue(reset.file(), reset.tree(), String.format("Rename this reset signal to preserve its name across the design. Source signal name: %s.", sourceSignalName), List.of(this.secondaryLocations(sourceSignal, reset)));
            }
        }
    }

    private String sourceSignalName(Object sourceSignal) {
        if (sourceSignal instanceof TreeFile) {
            return this.processedName(((IdentifierTree)((GenericTreeFile)sourceSignal).tree()).text());
        }
        return this.processedName(((String)sourceSignal).split("\\|")[0]);
    }

    private String processedSourceSignalName(Object sourceSignal) {
        return this.processedName(this.sourceSignalName(sourceSignal));
    }

    private String processedName(String name) {
        return name.replaceFirst("^" + this.prefixToIgnore, "").replaceFirst(this.suffixToIgnore + "$", "");
    }

    private HdlIssueLocation secondaryLocations(Object sourceSignal, SimpleReset reset) {
        if (sourceSignal instanceof TreeFile) {
            TreeFile s = (TreeFile)sourceSignal;
            return new HdlIssueLocation(s.file(), (Tree)s.tree(), "Source signal");
        }
        String[] splitSourceSignal = ((String)sourceSignal).split("\\|");
        return new HdlIssueLocation(reset.file(), reset.tree(), String.format("Source signal (unavailable in source code): %s (module: %s)", splitSourceSignal[0], splitSourceSignal[1]));
    }
}

