/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.VhdlBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierColonTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL1035")
public class ProcessLabelNamingConventionCheck
extends VhdlBugFinderCheck
implements BugFinderClocksAwareVisitor {
    private Clocks clocks;
    @RuleProperty(key="clockedSynthesisFormat", description="Regular expression to match for clocked processes in synthesis files.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String clockedSynthesisFormat = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    @RuleProperty(key="combinationalSynthesisFormat", description="Regular expression to match for combinational processes in synthesis files.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String combinationalSynthesisFormat = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    @RuleProperty(key="simulationFormat", description="Regular expression to match for processes in simulation files.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String simulationFormat = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = (Clocks)clocks;
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.isBugfinderEnabled()) {
            super.visitFile(tree);
        }
    }

    @Override
    public void visitProcessStatement(ProcessStatementTree tree) {
        IdentifierColonTree label = tree.label();
        if (label != null) {
            if (this.context().isSynthesisFile()) {
                if (this.clocks.isClockedProcess(this.context().file(), tree)) {
                    this.checkForNamingConventionIssue(label.identifier(), this.clockedSynthesisFormat);
                } else if (this.clocks.isCombinationalProcess(this.context().file(), tree)) {
                    this.checkForNamingConventionIssue(label.identifier(), this.combinationalSynthesisFormat);
                } else {
                    this.checkForNamingConventionIssue(label.identifier(), "(" + this.combinationalSynthesisFormat + ")|(" + this.clockedSynthesisFormat + ")");
                }
            } else {
                this.checkForNamingConventionIssue(label.identifier(), this.simulationFormat);
            }
        }
        super.visitProcessStatement(tree);
    }

    private void checkForNamingConventionIssue(IdentifierTree label, String format) {
        if (!Pattern.compile(format, 32).matcher(label.text()).matches()) {
            this.addPreciseIssue(label, "Rename this label to match the following regular expression: " + format);
        }
    }
}

