/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.reset.ResetsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetsAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Resets;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.SimpleReset;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.helpers.reset.ResetPolarity;
import com.lintyservices.yosys.helpers.reset.ResetType;
import java.text.MessageFormat;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL1026")
public class ResetNamingConventionCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderResetsAwareVisitor {
    private static final String SYNC_ACTIVE_LOW_DEFAULT_FORMAT = "^srst[a-z\\d_]*$";
    private static final String SYNC_ACTIVE_HIGH_DEFAULT_FORMAT = "^srst[a-z\\d_]*$";
    private static final String ASYNC_ACTIVE_LOW_DEFAULT_FORMAT = "^arst[a-z\\d_]*$";
    private static final String ASYNC_ACTIVE_HIGH_DEFAULT_FORMAT = "^arst[a-z\\d_]*$";
    private static final String MULTI_DEFAULT_FORMAT = "^rst[a-z\\d_]*$";
    private Set<SimpleReset> resets;
    @RuleProperty(key="syncActiveLowFormat", description="Regular expression for synchronous active-low resets to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^srst[a-z\\d_]*$")
    public String syncActiveLowFormat = "^srst[a-z\\d_]*$";
    @RuleProperty(key="syncActiveHighFormat", description="Regular expression for synchronous active-high resets to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^srst[a-z\\d_]*$")
    public String syncActiveHighFormat = "^srst[a-z\\d_]*$";
    @RuleProperty(key="asyncActiveLowFormat", description="Regular expression for asynchronous active-low resets to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^arst[a-z\\d_]*$")
    public String asyncActiveLowFormat = "^arst[a-z\\d_]*$";
    @RuleProperty(key="asyncActiveHighFormat", description="Regular expression for asynchronous active-high resets to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^arst[a-z\\d_]*$")
    public String asyncActiveHighFormat = "^arst[a-z\\d_]*$";
    @RuleProperty(key="multiFormat", description="Regular expression for multi-type (asynchronous and synchronous) or multi-polarity (active-low and active-high) resets to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^rst[a-z\\d_]*$")
    public String multiFormat = "^rst[a-z\\d_]*$";

    @Override
    public void setResets(ResetsInterface resets) {
        this.resets = ((Resets)resets).allSimpleResets();
    }

    @Override
    public final void retrieveIssues() {
        String format = null;
        for (SimpleReset reset : this.resets) {
            Pattern pattern;
            if (reset.polarities().size() > 1 || reset.types().size() > 1) {
                format = this.multiFormat;
            } else {
                ResetPolarity polarity = reset.polarities().stream().findFirst().orElse(null);
                ResetType type = reset.types().stream().findFirst().orElse(null);
                if (polarity == null) {
                    throw new LintyException("[ERROR] " + String.valueOf(this.getClass()) + ": polarity is null for " + reset.name());
                }
                if (type == null) {
                    throw new LintyException("[ERROR] " + String.valueOf(this.getClass()) + ": type is null for " + reset.name());
                }
                if (polarity == ResetPolarity.ACTIVE_LOW && type == ResetType.SYNCHRONOUS) {
                    format = this.syncActiveLowFormat;
                } else if (polarity == ResetPolarity.ACTIVE_HIGH && type == ResetType.SYNCHRONOUS) {
                    format = this.syncActiveHighFormat;
                } else if (polarity == ResetPolarity.ACTIVE_LOW && type == ResetType.ASYNCHRONOUS) {
                    format = this.asyncActiveLowFormat;
                } else if (polarity == ResetPolarity.ACTIVE_HIGH && type == ResetType.ASYNCHRONOUS) {
                    format = this.asyncActiveHighFormat;
                }
            }
            if ((pattern = Pattern.compile(format, 32)).matcher(reset.signalDeclaration().farRightName()).matches()) continue;
            String resetType = reset.hasBothTypes() ? "multiple types" : (reset.hasSynchronousType() ? ResetType.SYNCHRONOUS.value() : ResetType.ASYNCHRONOUS.value());
            String resetPolarity = reset.hasBothPolarities() ? "multiple polarities" : (reset.hasActiveHighPolarity() ? ResetPolarity.ACTIVE_HIGH.value() : ResetPolarity.ACTIVE_LOW.value());
            this.issues().addPreciseIssueWithFlows(reset.file(), reset.tree(), MessageFormat.format("Rename this \"{0}\" reset signal ({1}, {2}) to match the following regular expression: {3}", reset.signalDeclaration().farRightName(), resetType, resetPolarity, format), reset.usageAsFlows());
        }
    }
}

