/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.enable.EnablesInterface;
import com.lintyservices.sonar.plugins.bugfinder.objects.reset.ResetsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderEnablesAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.SignalDeclaration;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.ComplexEnable;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enable;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.EnableUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enables;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.SimpleEnable;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.ComplexReset;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Reset;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.ResetUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Resets;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.SimpleReset;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VHDL1053")
public class SignalUsageAsBothResetAndEnableCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderEnablesAwareVisitor,
BugFinderResetsAwareVisitor {
    private Set<SimpleEnable> simpleEnables;
    private Set<ComplexEnable> complexEnables;
    private Set<SimpleReset> simpleResets;
    private Set<ComplexReset> complexResets;

    @Override
    public void setEnables(EnablesInterface enables) {
        this.simpleEnables = ((Enables)enables).allSimpleEnables();
        this.complexEnables = ((Enables)enables).allComplexEnables();
    }

    @Override
    public void setResets(ResetsInterface resets) {
        this.simpleResets = ((Resets)resets).allSimpleResets();
        this.complexResets = ((Resets)resets).allComplexResets();
    }

    @Override
    public final void retrieveIssues() {
        for (Map.Entry<SignalDeclaration, Set<Object>> entry : this.getEnablesAndResets().entrySet()) {
            if (!this.containsBothEnablesAndResets(entry.getValue())) continue;
            this.issues().addPreciseIssueWithFlows(entry.getKey().treeFile().file(), (Tree)entry.getKey().treeFile().tree(), "Check this signal that is used as both a reset and an enable: " + entry.getKey().fullName(), this.getFlows(entry.getValue()));
        }
    }

    private Map<SignalDeclaration, Set<Object>> getEnablesAndResets() {
        HashMap<SignalDeclaration, Set<Object>> map = new HashMap<SignalDeclaration, Set<Object>>();
        for (SimpleEnable simpleEnable : this.simpleEnables) {
            this.addToMap(map, simpleEnable.signalDeclaration(), simpleEnable);
        }
        for (ComplexEnable complexEnable : this.complexEnables) {
            for (SignalDeclaration signalDeclaration : complexEnable.signalDeclarations()) {
                this.addToMap(map, signalDeclaration, complexEnable);
            }
        }
        for (SimpleReset simpleReset : this.simpleResets) {
            this.addToMap(map, simpleReset.signalDeclaration(), simpleReset);
        }
        for (ComplexReset complexReset : this.complexResets) {
            for (SignalDeclaration signalDeclaration : complexReset.signalDeclarations()) {
                this.addToMap(map, signalDeclaration, complexReset);
            }
        }
        return map;
    }

    private void addToMap(Map<SignalDeclaration, Set<Object>> map, SignalDeclaration signalDeclaration, Object element) {
        if (map.containsKey(signalDeclaration)) {
            map.get(signalDeclaration).add(element);
        } else {
            map.put(signalDeclaration, new HashSet());
            map.get(signalDeclaration).add(element);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsBothEnablesAndResets(Set<Object> elements) {
        if (!elements.stream().anyMatch(Reset.class::isInstance)) return false;
        if (!elements.stream().anyMatch(Enable.class::isInstance)) return false;
        return true;
    }

    private List<List<? extends IssueLocationInterface>> getFlows(Set<Object> elements) {
        ArrayList<List<? extends IssueLocationInterface>> flows = new ArrayList<List<? extends IssueLocationInterface>>();
        ArrayList<HdlIssueLocation> resetFlow = new ArrayList<HdlIssueLocation>();
        ArrayList<HdlIssueLocation> enableFlow = new ArrayList<HdlIssueLocation>();
        for (Object element : elements) {
            if (element instanceof SimpleEnable) {
                SimpleEnable simpleEnable = (SimpleEnable)element;
                enableFlow.addAll(simpleEnable.usage().stream().filter(EnableUsage::isYosysEnableUsage).map(u -> new HdlIssueLocation(u.file(), u.tree(), "Enable usage")).toList());
                continue;
            }
            if (element instanceof ComplexEnable) {
                ComplexEnable complexEnable = (ComplexEnable)element;
                enableFlow.add(new HdlIssueLocation(complexEnable.file(), complexEnable.flipFlopIfStatement(), "Complex enable usage"));
                continue;
            }
            if (element instanceof SimpleReset) {
                SimpleReset simpleReset = (SimpleReset)element;
                resetFlow.addAll(simpleReset.usage().stream().filter(ResetUsage::isYosysResetUsage).map(u -> new HdlIssueLocation(u.file(), u.tree(), "Reset usage")).toList());
                continue;
            }
            if (!(element instanceof ComplexReset)) continue;
            ComplexReset complexReset = (ComplexReset)element;
            resetFlow.add(new HdlIssueLocation(complexReset.file(), complexReset.ifElsifConditionTree(), "Complex reset usage"));
        }
        flows.add(enableFlow);
        flows.add(resetFlow);
        return flows;
    }
}

