/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SubtypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.Node;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.SubtypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TypeAndSubtypeTreeFileUtils;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.ArrayTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstantDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EnumerationTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.GenericClauseTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.RecordTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VariableDeclarationTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL303")
public class AllowedTypeCheck
extends VhdlDoubleDispatchVisitorCheck
implements TypeTreeFileAwareVisitor,
SubtypeTreeFileAwareVisitor {
    public static final String DEFAULT_ALLOWED_TYPES = "bit,bit_vector,integer,natural,positive,signed,std_logic,std_logic_vector,std_ulogic,std_ulogic_vector,unsigned";
    public static final String ADDITIONAL_ALLOWED_TYPES_FOR_GENERIC = "boolean";
    public static final boolean ALLOW_ALL_ENUMERATED_TYPES = true;
    private Set<String> allowedTypesAsSet;
    private Set<String> allowedTypesForGenericAsSet;
    private List<TypeTreeFile> arrayTypes = new ArrayList<TypeTreeFile>();
    private List<TypeTreeFile> recordTypes = new ArrayList<TypeTreeFile>();
    private List<SubtypeTreeFile> subtypes = new ArrayList<SubtypeTreeFile>();
    private Set<String> enumeratedTypes = new HashSet<String>();
    @RuleProperty(key="allowedTypes", description="Comma separated list of allowed types.", defaultValue="bit,bit_vector,integer,natural,positive,signed,std_logic,std_logic_vector,std_ulogic,std_ulogic_vector,unsigned")
    public String allowedTypes = "bit,bit_vector,integer,natural,positive,signed,std_logic,std_logic_vector,std_ulogic,std_ulogic_vector,unsigned";
    @RuleProperty(key="additionalAllowedTypesForGeneric", description="Comma separated list of additional allowed types for generic.", defaultValue="boolean")
    public String additionalAllowedTypesForGeneric = "boolean";
    @RuleProperty(key="allowAllEnumeratedTypes", description="Set to 'true' to allow all enumerated types. Set to 'false' otherwise.", defaultValue="true")
    public boolean allowAllEnumeratedTypes = true;

    @Override
    public void setTypes(Set<TypeTreeFile> types) {
        this.arrayTypes = types.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof ArrayTypeDefinitionTree).sorted(new TreeFileComparator()).toList();
        this.recordTypes = types.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof RecordTypeDefinitionTree).sorted(new TreeFileComparator()).toList();
        this.enumeratedTypes = types.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof EnumerationTypeDefinitionTree).map(t -> ((FullTypeDeclarationTree)t.tree()).identifier().text().toLowerCase()).collect(Collectors.toSet());
    }

    @Override
    public void setSubtypes(Set<SubtypeTreeFile> subtypes) {
        this.subtypes = subtypes.stream().sorted(new TreeFileComparator()).toList();
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.allowedTypesAsSet = this.convertAllowedTypesFromCommaSeparatedStringToSet(this.allowedTypes);
        if (this.context().isSynthesisFile()) {
            if (this.allowAllEnumeratedTypes) {
                this.allowedTypesAsSet.addAll(this.enumeratedTypes);
            }
            this.allowedTypesForGenericAsSet = this.convertAllowedTypesFromCommaSeparatedStringToSet(this.additionalAllowedTypesForGeneric);
            this.allowedTypesForGenericAsSet.addAll(this.allowedTypesAsSet);
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitSignalDeclaration(SignalDeclarationTree tree) {
        this.checkType(tree.subtypeIndication().typeName(), this.allowedTypesAsSet);
        super.visitSignalDeclaration(tree);
    }

    @Override
    public void visitConstantDeclaration(ConstantDeclarationTree tree) {
        this.checkType(tree.subtypeIndication().typeName(), this.allowedTypesAsSet);
        super.visitConstantDeclaration(tree);
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        this.checkType(tree.subtypeIndication().typeName(), this.allowedTypesAsSet);
        super.visitVariableDeclaration(tree);
    }

    @Override
    public void visitGenericClause(GenericClauseTree tree) {
        tree.generics().interfaces().stream().filter(d -> d.isOneOf(VhdlTree.Kind.INTERFACE_SIGNAL_DECLARATION, VhdlTree.Kind.INTERFACE_CONSTANT_DECLARATION, VhdlTree.Kind.INTERFACE_VARIABLE_DECLARATION)).forEach(d -> this.checkType(d.type().typeName(), this.allowedTypesForGenericAsSet));
        super.visitGenericClause(tree);
    }

    private void checkType(NameTree tree, Set<String> allowedTypes) {
        Node<GenericTreeFile<NameTree>> node = new Node<GenericTreeFile<NameTree>>(new GenericTreeFile<NameTree>(tree, this.context().file()));
        TypeAndSubtypeTreeFileUtils.buildNameTree(node, this.arrayTypes, this.recordTypes, this.subtypes);
        this.checkType(node, allowedTypes);
    }

    private void checkType(Node<GenericTreeFile<NameTree>> node, Set<String> allowedTypes) {
        if (node.isLeaf()) {
            NameTree tree = (NameTree)node.getData().tree();
            String type = tree.firstToken().firstToken().text().toLowerCase();
            if (!allowedTypes.contains(type)) {
                this.addIssue(tree, allowedTypes, null);
            }
        } else {
            for (Node<GenericTreeFile<NameTree>> leaf : node.getAllLeaves()) {
                NameTree tree = (NameTree)leaf.getData().tree();
                String type = tree.firstToken().firstToken().text().toLowerCase();
                if (allowedTypes.contains(type)) continue;
                Stack<Node<GenericTreeFile<NameTree>>> flowAsStack = new Stack<Node<GenericTreeFile<NameTree>>>();
                flowAsStack.push(leaf);
                flowAsStack.addAll(leaf.getAncestors());
                List<HdlIssueLocation> flowAsList = flowAsStack.stream().filter(a -> a.getParent() != null).map(a -> new HdlIssueLocation(((GenericTreeFile)a.getData()).file(), (Tree)((GenericTreeFile)a.getData()).tree(), "Related type")).toList();
                this.addIssue((VhdlTree)node.getData().tree(), allowedTypes, List.of(flowAsList));
            }
        }
    }

    private void addIssue(VhdlTree tree, Set<String> allowedTypes, @Nullable List<List<? extends IssueLocationInterface>> flows) {
        String message = "Replace by one of the following allowed types: " + allowedTypes.stream().sorted().collect(Collectors.joining(", ")) + (this.allowAllEnumeratedTypes ? ", any enumerated type" : "") + ", subtype of those types, record of those types or array of those types.";
        if (flows != null) {
            this.addPreciseIssueWithFlows(tree, message, flows);
        } else {
            this.addPreciseIssue(tree, message);
        }
    }

    private Set<String> convertAllowedTypesFromCommaSeparatedStringToSet(String allowedTypes) {
        return Arrays.stream(allowedTypes.split(",")).map(String::trim).map(String::toLowerCase).collect(Collectors.toSet());
    }
}

