/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL005")
public class ArchitectureNamingConventionCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final String DEFAULT_SYNTHESIS_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    private static final String DEFAULT_SIMULATION_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    private String format;
    @RuleProperty(key="synthesisFormat", description="Regular expression to match for architecture in synthesis file.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com\nAdd the following pattern into your regular expression to match the related entity name: {ENTITY_NAME}", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String synthesisFormat = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    @RuleProperty(key="simulationFormat", description="Regular expression to match for architecture in simulation file.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com\nAdd the following pattern into your regular expression to match the related entity name: {ENTITY_NAME}", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String simulationFormat = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.format = this.context().isSimulationFile() ? this.simulationFormat : this.synthesisFormat;
        super.visitDesignFile(tree);
    }

    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        String processedRegularExpression = this.format.replace("{ENTITY_NAME}", tree.entityName().text());
        Pattern pattern = Pattern.compile(processedRegularExpression, 32);
        if (!pattern.matcher(tree.identifier().text()).matches()) {
            this.addPreciseIssue(tree.identifier(), String.format("Rename this architecture to match the following regular expression: %s", processedRegularExpression));
        }
        super.visitArchitectureBody(tree);
    }
}

