/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SimpleWaveformSignalAssignmentStatementTree;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL132")
public class AssignedSignalFromSensitivityListCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitProcessStatement(ProcessStatementTree tree) {
        if (tree.sensitivity() != null) {
            Set sensitivityListSignalNames = tree.sensitivity().nameList().stream().map(s -> s.lastToken().text()).collect(Collectors.toSet());
            tree.statementPart().allChildren(VhdlTree.Kind.SIMPLE_WAVEFORM_SIGNAL_ASSIGNMENT_STATEMENT).forEach(s -> {
                SimpleWaveformSignalAssignmentStatementTree signalAssignment = (SimpleWaveformSignalAssignmentStatementTree)s;
                if (sensitivityListSignalNames.contains(signalAssignment.target().firstToken().text())) {
                    this.addPreciseIssue(signalAssignment.target(), "Do not assign this signal that is listed in the process' sensitivity list.", List.of(new HdlIssueLocation(tree.sensitivity())));
                }
            });
        }
    }
}

