/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortClauseTree;
import com.lintyservices.utils.LintyException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL025")
public class BadPortModeCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final Set<String> ALLOWED_PORT_MODES_FOR_TOP_LEVEL_ENTITIES = Stream.of(VhdlKeyword.IN, VhdlKeyword.OUT, VhdlKeyword.INOUT).map(VhdlKeyword::getValue).collect(Collectors.toSet());
    private static final Set<String> ALLOWED_PORT_MODES_FOR_LOW_LEVEL_ENTITIES = Stream.of(VhdlKeyword.IN, VhdlKeyword.OUT).map(VhdlKeyword::getValue).collect(Collectors.toSet());
    private String topLevelEntity;
    private Set<String> entityExceptionSet;
    @RuleProperty(key="entityExceptions", description="Comma-separated list of additional entities allowing usage of \"inout\" port mode.")
    public String entityExceptions = "";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().topLevelModule() == null) {
            throw new LintyException("Check vhdl:VHDL025: sonar.hdl.topModule property is not set");
        }
        this.topLevelEntity = this.context().topLevelModule();
        this.entityExceptionSet = Arrays.stream(this.entityExceptions.split(",")).map(String::trim).collect(Collectors.toSet());
        super.visitDesignFile(tree);
    }

    @Override
    public void visitPortClause(PortClauseTree tree) {
        EntityDeclarationTree entity;
        List<InterfaceDeclarationTree> ports = tree.ports().interfaces();
        if (!ports.isEmpty() && (entity = (EntityDeclarationTree)tree.ancestor(VhdlTree.Kind.ENTITY_DECLARATION)) != null) {
            Set<String> allowedPortModes = this.isTopLevelEntity(entity) || this.isEntityException(entity) ? ALLOWED_PORT_MODES_FOR_TOP_LEVEL_ENTITIES : ALLOWED_PORT_MODES_FOR_LOW_LEVEL_ENTITIES;
            for (InterfaceDeclarationTree port : ports) {
                if (port.mode() == null || allowedPortModes.contains(port.mode().text().toLowerCase())) continue;
                this.raiseIssue(port, allowedPortModes);
            }
        }
        super.visitPortClause(tree);
    }

    private void raiseIssue(InterfaceDeclarationTree port, Set<String> allowedPorts) {
        this.addPreciseIssue(port.mode(), "Replace by one of the following allowed port modes: " + allowedPorts.stream().sorted().collect(Collectors.joining(", ")));
    }

    private boolean isTopLevelEntity(EntityDeclarationTree entity) {
        return this.topLevelEntity.equals(entity.identifier().text());
    }

    private boolean isEntityException(EntityDeclarationTree entity) {
        return this.entityExceptionSet.contains(entity.identifier().text());
    }
}

