/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstraintTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DiscreteRangeTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IndexConstraintTree;
import com.lintyservices.sonar.plugins.vhdl.parser.RangeWithDirectionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL036")
public class BadVectorDirectionCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final boolean USE_DOWNTO_DEFAULT = true;
    @RuleProperty(key="useDownto", defaultValue="true", description="Set to true to check vector directions are 'DOWNTO'. When set to false, vector directions 'TO' are checked.")
    public boolean useDownto = true;

    @Override
    public void visitSubtypeIndication(SubtypeIndicationTree tree) {
        List<ConstraintTree> constraints;
        if (tree.typeName().firstToken().text().equalsIgnoreCase("std_logic_vector") && (constraints = tree.constraint()) != null) {
            for (ConstraintTree constraint : constraints) {
                if (!constraint.is(VhdlTree.Kind.INDEX_CONSTRAINT)) continue;
                List<DiscreteRangeTree> ranges = ((IndexConstraintTree)constraint).ranges();
                for (DiscreteRangeTree range : ranges) {
                    RangeWithDirectionTree rangeTree;
                    if (!range.is(VhdlTree.Kind.RANGE_WITH_DIRECTION) || (rangeTree = (RangeWithDirectionTree)range).direction().getGrammarRuleKey() != (this.useDownto ? VhdlKeyword.TO : VhdlKeyword.DOWNTO)) continue;
                    this.addPreciseIssue(this.context().file(), rangeTree.direction(), String.format("Use '%s' vector direction.", this.useDownto ? VhdlKeyword.DOWNTO : VhdlKeyword.TO));
                }
            }
        }
        super.visitSubtypeIndication(tree);
    }
}

