/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ChoiceTree;
import com.lintyservices.sonar.plugins.vhdl.parser.OthersKeywordTreeImpl;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL237")
public class CaseOthersLastClauseCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    @Override
    public void visitCaseStatement(CaseStatementTree tree) {
        ChoiceTree defaultClause = CaseOthersLastClauseCheck.getDefaultClause(tree);
        if (defaultClause != null && !defaultClause.equals(CaseOthersLastClauseCheck.getLastClause(tree))) {
            this.addPreciseIssue(defaultClause, "Move this \"others\" clause to the end of the case.", List.of(new HdlIssueLocation(tree.endKeyword(), "End case")));
        }
        super.visitCaseStatement(tree);
    }

    private static ChoiceTree getDefaultClause(CaseStatementTree caseStatementTree) {
        return caseStatementTree.alternatives().stream().flatMap(caseGroup -> caseGroup.choices() != null ? caseGroup.choices().choices().stream() : null).filter(OthersKeywordTreeImpl.class::isInstance).findFirst().orElse(null);
    }

    private static ChoiceTree getLastClause(CaseStatementTree caseStatementTree) {
        return caseStatementTree.alternatives().stream().flatMap(caseGroup -> caseGroup.choices() != null ? caseGroup.choices().choices().stream() : null).reduce((first, second) -> second).orElse(null);
    }
}

