/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseStatementTree;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL217")
public class CaseTooManyWhenClausesCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final int MAXIMUM_NUMBER_OF_WHEN_CLAUSES = 16;
    @RuleProperty(key="maxNumberOfWhenClauses", description="Maximum allowed number of 'when' clauses.", defaultValue="16")
    public int maxNumberOfWhenClauses = 16;

    @Override
    public void visitCaseStatement(CaseStatementTree tree) {
        if (tree.alternatives().size() > this.maxNumberOfWhenClauses) {
            this.addPreciseIssue(this.context().file(), tree.beginStatementKeyword(), String.format("Update design to split this case statement. Actual number of \"when\" clauses: %d. Maximum number of allowed \"when\" clauses: %d.", tree.alternatives().size(), this.maxNumberOfWhenClauses));
        }
        super.visitCaseStatement(tree);
    }
}

