/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.CommentLinesVisitor;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.LinesOfCodeVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL307")
public class CommentsRatioCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final int DEFAULT_MIN_SYNTHESIS = 20;
    private static final int DEFAULT_MIN_SIMULATION = 10;
    @RuleProperty(key="min_synthesis", description="Minimum comments ratio on synthesis files (integer between 0 and 100)", defaultValue="20", type="INTEGER")
    public int minSynthesis = 20;
    @RuleProperty(key="min_simulation", description="Minimum comments ratio on simulation files (integer between 0 and 100)", defaultValue="10")
    public int minSimulation = 10;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        double minCommentsRatio;
        int linesOfCode;
        int linesOfComments = new CommentLinesVisitor(tree).getNumberOfCommentLines();
        double commentsRatio = (double)linesOfComments / (double)(linesOfCode = new LinesOfCodeVisitor(tree).getNumberOfLinesOfCode()) * 100.0;
        if (commentsRatio < (minCommentsRatio = (double)(this.context().isSynthesisFile() ? this.minSynthesis : this.minSimulation))) {
            this.addFileIssue(MessageFormat.format("This file has a {0}% comments ratio, which is lower than the expected ratio of {1}%. Add more comments.", new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(Locale.ENGLISH)).format(commentsRatio), new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(Locale.ENGLISH)).format(minCommentsRatio)));
        }
        super.visitDesignFile(tree);
    }
}

