/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL232")
public class CppKeywordCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    public static final List<String> CPP_KEYWORDS = List.of("alignas", "alignof", "and", "and_eq", "asm", "atomic_cancel", "atomic_commit", "atomic_noexcept", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "char8_t", "class", "co_await", "co_return", "co_yield", "compl", "concept", "const", "const_cast", "consteval", "constexpr", "constinit", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "reflexpr", "register", "reinterpret_cast", "requires", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "synchronized", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq");

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        this.checkForIssue(tree.identifier());
        for (IdentifierTree identifier : tree.allPortIdentifiers()) {
            this.checkForIssue(identifier);
        }
        for (IdentifierTree identifier : tree.genericIdentifiers()) {
            this.checkForIssue(identifier);
        }
        super.visitEntityDeclaration(tree);
    }

    private void checkForIssue(IdentifierTree identifier) {
        if (CPP_KEYWORDS.contains(identifier.text().toLowerCase())) {
            this.addPreciseIssue(identifier, "Rename this identifier as it matches a C++ keyword.");
        }
    }
}

