/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL184")
public class EntityArchitectureSameFileCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private Set<String> entityNames;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.entityNames = tree.entities().stream().map(e -> e.identifier().text()).collect(Collectors.toSet());
        super.visitDesignFile(tree);
    }

    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        if (!this.entityNames.contains(tree.entityName().text())) {
            this.addPreciseIssue(tree.identifier(), "Define this architecture in the same file as its entity.");
        }
    }
}

