/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL316")
public class EntityTooManyPortsCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final int DEFAULT_MAX_NUMBER_OF_PORTS = 6;
    private static final boolean DEFAULT_CHECK_TOP_ENTITY = false;
    @RuleProperty(key="max", description="The maximum allowed number of ports.", type="INTEGER", defaultValue="6")
    public int max = 6;
    @RuleProperty(key="checkTopEntity", description="Set to 'true', to check this rule on top entity, set to 'false' otherwise.", type="BOOLEAN", defaultValue="false")
    public boolean checkTopEntity = false;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        if ((!tree.identifier().text().equalsIgnoreCase(this.context().topLevelModule()) || tree.identifier().text().equalsIgnoreCase(this.context().topLevelModule()) && this.checkTopEntity) && tree.portIdentifiers().size() > this.max) {
            this.addPreciseIssue(tree.identifier(), String.format("Too many ports. Actual: %d. Allowed: %d. Split this entity into single-responsibility entities.", tree.portIdentifiers().size(), this.max), tree.portIdentifiers().stream().map(HdlIssueLocation::new).toList());
        }
        super.visitEntityDeclaration(tree);
    }
}

