/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.SynthesisFilesToAnalyzeAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ArchitectureTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.EntityTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.utils.FileUtils;
import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL306")
public class EntityWithMoreThanOneArchitectureCheck
extends VhdlDoubleDispatchVisitorCheck
implements CrossFileCheck,
ArchitectureTreeFileAwareVisitor,
EntityTreeFileAwareVisitor,
SynthesisFilesToAnalyzeAwareVisitor {
    private Set<EntityTreeFile> entities;
    private Set<ArchitectureTreeFile> architectures;
    private Set<File> synthesisFilesToAnalyze;

    @Override
    public void setEntities(Set<EntityTreeFile> entities) {
        this.entities = entities;
    }

    @Override
    public void setArchitectures(Set<ArchitectureTreeFile> architectures) {
        this.architectures = architectures;
    }

    @Override
    public void setSynthesisFilesToAnalyze(Set<File> synthesisFilesToAnalyze) {
        this.synthesisFilesToAnalyze = synthesisFilesToAnalyze;
    }

    @Override
    public final void checkForIssues() {
        Set synthesisEntities = this.entities.stream().filter(e -> FileUtils.contains(this.synthesisFilesToAnalyze, e.file())).collect(Collectors.toSet());
        Set<ArchitectureTreeFile> synthesisArchitectures = this.architectures.stream().filter(a -> FileUtils.contains(this.synthesisFilesToAnalyze, a.file())).collect(Collectors.toSet());
        for (EntityTreeFile entity : synthesisEntities) {
            Set<ArchitectureTreeFile> relatedArchitectures = this.relatedArchitectures(((EntityDeclarationTree)entity.tree()).identifier().text(), synthesisArchitectures);
            if (relatedArchitectures.size() <= 1) continue;
            this.addPreciseIssue(entity.file(), ((EntityDeclarationTree)entity.tree()).identifier(), "Keep only one single architecture for this entity.", relatedArchitectures.stream().map(a -> new HdlIssueLocation(a.file(), ((ArchitectureBodyTree)a.tree()).identifier(), "Related architecture")).toList());
        }
    }

    private Set<ArchitectureTreeFile> relatedArchitectures(String entityName, Set<ArchitectureTreeFile> synthesisArchitectures) {
        return synthesisArchitectures.stream().filter(a -> ((ArchitectureBodyTree)a.tree()).entityName().text().equals(entityName)).collect(Collectors.toSet());
    }
}

