/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL233")
public class ExternalSignalVariableSynthesizableFunctionProcedureCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private List<IdentifierTree> externalSignals;
    private List<IdentifierTree> externalVariables;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            this.externalSignals = new ArrayList<IdentifierTree>();
            this.externalVariables = new ArrayList<IdentifierTree>();
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        this.externalSignals = tree.declarativePart().blockDeclarativeItems().stream().filter(o -> o.is(VhdlTree.Kind.SIGNAL_DECLARATION)).map(MultipleDeclarationTree.class::cast).map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).toList();
        this.externalVariables = tree.declarativePart().blockDeclarativeItems().stream().filter(o -> o.is(VhdlTree.Kind.VARIABLE_DECLARATION)).map(MultipleDeclarationTree.class::cast).map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).toList();
        super.visitArchitectureBody(tree);
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (tree.hasAncestor(VhdlTree.Kind.SUBPROGRAM_BODY) && tree.hasAncestor(VhdlTree.Kind.SEQUENCE_OF_STATEMENTS)) {
            for (IdentifierTree externalSignal : this.externalSignals) {
                if (!externalSignal.text().equalsIgnoreCase(tree.text())) continue;
                this.addPreciseIssue(tree, "Remove this external signal that should not be used in synthesizable function/procedure.", List.of(new HdlIssueLocation(externalSignal, "External signal")));
                return;
            }
            for (IdentifierTree externalVariable : this.externalVariables) {
                if (!externalVariable.text().equalsIgnoreCase(tree.text())) continue;
                this.addPreciseIssue(tree, "Remove this external variable that should not be used in synthesizable function/procedure.", List.of(new HdlIssueLocation(externalVariable, "External variable")));
                return;
            }
        }
    }
}

