/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.BlockTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignUnitTree;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL180")
public class FileNamingConventionCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    public static final String DEFAULT_FORMAT_SYNTHESIS_ONE_SINGLE_DESIGN_UNIT = "^{DESIGN_UNIT}\\.(vhd|vhdl)$";
    public static final String DEFAULT_FORMAT_SYNTHESIS_OTHERS = "^[a-z][a-z0-9_]*\\.(vhd|vhdl)$";
    public static final String DEFAULT_FORMAT_SIMULATION_ONE_SINGLE_DESIGN_UNIT = "^{DESIGN_UNIT}\\.(vhd|vhdl)$";
    public static final String DEFAULT_FORMAT_SIMULATION_OTHERS = "^[a-z][a-z0-9_]*\\.(vhd|vhdl)$";
    private static final String COMMON_DESCRIPTION_ONE_SINGLE_UNIT_FORMAT = "See documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com\n{DESIGN_UNIT} placeholder can be used in regular expression. For instance: ^{DESIGN_UNIT}[a-z_]*\\.(vhd|vhdl)$ means that the name of the file should start with the name of the design unit (entity, configuration, package, package body or context) it defines and additional characters after the name of the design unit are allowed.";
    @RuleProperty(key="synthesisOneSingleUnitFormat", description="Regular expression for synthesis files defining one single design unit.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com\n{DESIGN_UNIT} placeholder can be used in regular expression. For instance: ^{DESIGN_UNIT}[a-z_]*\\.(vhd|vhdl)$ means that the name of the file should start with the name of the design unit (entity, configuration, package, package body or context) it defines and additional characters after the name of the design unit are allowed.", defaultValue="^{DESIGN_UNIT}\\.(vhd|vhdl)$")
    public String synthesisOneSingleUnitFormat = "^{DESIGN_UNIT}\\.(vhd|vhdl)$";
    @RuleProperty(key="synthesisOthersFormat", description="Regular expression for synthesis files defining several design units or no design unit.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", defaultValue="^[a-z][a-z0-9_]*\\.(vhd|vhdl)$")
    public String synthesisOthersFormat = "^[a-z][a-z0-9_]*\\.(vhd|vhdl)$";
    @RuleProperty(key="simulationOneSingleUnitFormat", description="Regular expression for simulation files defining one single design unit.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com\n{DESIGN_UNIT} placeholder can be used in regular expression. For instance: ^{DESIGN_UNIT}[a-z_]*\\.(vhd|vhdl)$ means that the name of the file should start with the name of the design unit (entity, configuration, package, package body or context) it defines and additional characters after the name of the design unit are allowed.", defaultValue="^{DESIGN_UNIT}\\.(vhd|vhdl)$")
    public String simulationOneSingleUnitFormat = "^{DESIGN_UNIT}\\.(vhd|vhdl)$";
    @RuleProperty(key="simulationOthersFormat", description="Regular expression for simulation files defining several design units or no design unit.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z][a-z0-9_]*\\.(vhd|vhdl)$")
    public String simulationOthersFormat = "^[a-z][a-z0-9_]*\\.(vhd|vhdl)$";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        long numberOfUnits = tree.units().stream().map(DesignUnitTree::libraryUnit).filter(l -> l.isOneOf(VhdlTree.Kind.ENTITY_DECLARATION, VhdlTree.Kind.PACKAGE_DECLARATION, VhdlTree.Kind.PACKAGE_BODY, VhdlTree.Kind.CONFIGURATION_DECLARATION, VhdlTree.Kind.CONTEXT_DECLARATION)).count();
        String firstUnitName = tree.units().stream().map(DesignUnitTree::libraryUnit).filter(l -> l.isOneOf(VhdlTree.Kind.ENTITY_DECLARATION, VhdlTree.Kind.PACKAGE_DECLARATION, VhdlTree.Kind.PACKAGE_BODY, VhdlTree.Kind.CONFIGURATION_DECLARATION, VhdlTree.Kind.CONTEXT_DECLARATION)).map(l -> ((BlockTree)((Object)l)).identifier().text()).findFirst().orElse("");
        String format = numberOfUnits == 1L ? (this.context().isSimulationFile() ? this.simulationOneSingleUnitFormat : this.synthesisOneSingleUnitFormat) : (this.context().isSimulationFile() ? this.simulationOthersFormat : this.synthesisOthersFormat);
        Pattern pattern = Pattern.compile(format.replace("{DESIGN_UNIT}", firstUnitName), 32);
        if (!pattern.matcher(this.context().file().getName()).matches()) {
            this.addFileIssue("Rename this file to match the following regular expression: " + format);
        }
    }
}

