/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.UseClauseTree;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL312")
public class ForbiddenLibrariesCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final String DEFAULT_FORBIDDEN_LIBRARIES = "";
    private Set<String> forbiddenLibrariesAsList;
    @RuleProperty(key="libraries", description="Comma-separated list of forbidden libraries.\nA library could be:\n  - A global library such as 'ieee'\n  - A specific package such as 'ieee.std_logic_1164'", defaultValue="")
    public String forbiddenLibraries = "";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.forbiddenLibrariesAsList = Arrays.stream(this.forbiddenLibraries.split(",")).map(l -> l.trim().toLowerCase()).filter(l -> !l.isEmpty()).collect(Collectors.toSet());
        super.visitDesignFile(tree);
    }

    @Override
    public void visitUseClause(UseClauseTree tree) {
        for (SelectedNameTree library : tree.libraries().list().elements()) {
            if (!this.forbiddenLibrariesAsList.stream().anyMatch(l -> library.toString().toLowerCase().startsWith((String)l))) continue;
            this.addPreciseIssue(library, "Replace this forbidden library.");
        }
        super.visitUseClause(tree);
    }
}

