/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL222")
public class ForbiddenPragmasCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final String DEFAULT_FORBIDDEN_PRAGMAS = "translate_on,translate_off,synthesis_on,synthesis_off,RTL_SYNTHESIS OFF,RTL_SYNTHESIS ON,vhdl_comp_on,vhdl_comp_off";
    private Set<String> forbiddenPragmasAsSet;
    @RuleProperty(key="pragmas", description="Comma-separated list of forbidden pragmas", defaultValue="translate_on,translate_off,synthesis_on,synthesis_off,RTL_SYNTHESIS OFF,RTL_SYNTHESIS ON,vhdl_comp_on,vhdl_comp_off")
    public String forbiddenPragmas = "translate_on,translate_off,synthesis_on,synthesis_off,RTL_SYNTHESIS OFF,RTL_SYNTHESIS ON,vhdl_comp_on,vhdl_comp_off";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.forbiddenPragmasAsSet = Arrays.stream(this.forbiddenPragmas.split(",")).map(l -> l.trim().toLowerCase()).filter(l -> !l.isEmpty()).collect(Collectors.toSet());
        super.visitDesignFile(tree);
    }

    @Override
    public void visitInternalSyntaxTrivia(SyntaxTrivia trivia) {
        String comment = trivia.text();
        for (String forbiddenPragma : this.forbiddenPragmasAsSet) {
            if (!StringUtils.containsIgnoreCase(comment, forbiddenPragma) || ForbiddenPragmasCheck.isLetterAround(comment, forbiddenPragma)) continue;
            this.addPreciseIssue(trivia, "Remove this forbidden pragma.");
        }
    }

    private static boolean isLetterAround(String line, String pattern) {
        int start = StringUtils.indexOfIgnoreCase(line, pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 && Character.isLetter(line.charAt(start - 1));
        boolean post = end < line.length() - 1 && Character.isLetter(line.charAt(end));
        return pre || post;
    }
}

