/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlTokenType;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.util.regex.Pattern;
import org.sonar.check.Rule;

@Rule(key="VHDL301")
public class ForbiddenStdLogicValuesCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitInternalSyntaxToken(VhdlInternalSyntaxToken token) {
        if (token.getGrammarRuleKey() == VhdlTokenType.CHARACTER_LITERAL || token.getGrammarRuleKey() == VhdlTokenType.STRING_LITERAL) {
            String tokenWithoutQuotes = new StringBuilder(token.text()).deleteCharAt(token.text().length() - 1).deleteCharAt(0).toString();
            Pattern pattern = Pattern.compile("[10ZWLHUXzwlhux-]+", 32);
            if (pattern.matcher(tokenWithoutQuotes).matches()) {
                if (tokenWithoutQuotes.toLowerCase().contains("u")) {
                    this.addPreciseIssue(token, "Remove this forbidden value: U");
                }
                if (tokenWithoutQuotes.toLowerCase().contains("x")) {
                    this.addPreciseIssue(token, "Remove this forbidden value: X");
                }
                if (tokenWithoutQuotes.toLowerCase().contains("w")) {
                    this.addPreciseIssue(token, "Remove this forbidden value: W");
                }
                if (tokenWithoutQuotes.toLowerCase().contains("l")) {
                    this.addPreciseIssue(token, "Remove this forbidden value: L");
                }
                if (tokenWithoutQuotes.toLowerCase().contains("h")) {
                    this.addPreciseIssue(token, "Remove this forbidden value: H");
                }
                if (tokenWithoutQuotes.toLowerCase().contains("-")) {
                    this.addPreciseIssue(token, "Remove this forbidden value: -");
                }
            }
        }
        super.visitInternalSyntaxToken(token);
    }
}

