/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceSignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortClauseTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL210")
public class FormatPortClauseCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final boolean DEFAULT_ONE_SINGLE_WHITESPACE = true;
    @RuleProperty(key="oneSingleWhitespace", description="Set to 'true' to force alignment one single whitespace after the longest preceding column, set to 'false' otherwise.", type="BOOLEAN", defaultValue="true")
    public boolean oneSingleWhitespace = true;

    @Override
    public void visitPortClause(PortClauseTree tree) {
        List<InterfaceSignalDeclarationTree> signalDeclarations = this.getSignalDeclarationList(tree);
        boolean noIssue = this.checkThatParenthesesAreOnDedicatedLine(tree, signalDeclarations);
        if (noIssue) {
            noIssue = this.checkThatEachDeclarationIsOnDedicatedLine(tree, signalDeclarations);
        }
        if (noIssue) {
            noIssue = this.checkThatColonsAreVerticallyAligned(tree, signalDeclarations);
        }
        if (noIssue) {
            noIssue = this.checkThatModesAreVerticallyAligned(tree, signalDeclarations);
        }
        if (noIssue) {
            this.checkThatTypesAreVerticallyAligned(tree, signalDeclarations);
        }
        super.visitPortClause(tree);
    }

    private List<InterfaceSignalDeclarationTree> getSignalDeclarationList(PortClauseTree tree) {
        ArrayList<InterfaceSignalDeclarationTree> signalDeclarations = new ArrayList<InterfaceSignalDeclarationTree>();
        for (InterfaceDeclarationTree declaration : tree.ports().interfaces()) {
            if (!declaration.is(VhdlTree.Kind.INTERFACE_SIGNAL_DECLARATION)) continue;
            signalDeclarations.add((InterfaceSignalDeclarationTree)declaration);
        }
        return signalDeclarations;
    }

    private boolean checkThatParenthesesAreOnDedicatedLine(PortClauseTree tree, List<InterfaceSignalDeclarationTree> signalDeclarations) {
        boolean noIssue = true;
        int openingParenthesisLine = tree.openingParenthesis().line();
        int closingParenthesisLine = tree.closingParenthesis().line();
        List<InterfaceSignalDeclarationTree> declarationsOnOpeningParenthesisLine = signalDeclarations.stream().filter(s -> s.firstToken().line() == openingParenthesisLine).toList();
        List<InterfaceSignalDeclarationTree> declarationsOnClosingParenthesisLine = signalDeclarations.stream().filter(s -> s.lastToken().line() == closingParenthesisLine).toList();
        if (!declarationsOnOpeningParenthesisLine.isEmpty()) {
            this.addPreciseIssue(tree.openingParenthesis(), "Move the opening parenthesis to its own line.");
            noIssue = false;
        }
        if (!declarationsOnClosingParenthesisLine.isEmpty()) {
            this.addPreciseIssue(tree.closingParenthesis(), "Move the closing parenthesis to its own line.");
            noIssue = false;
        }
        return noIssue;
    }

    private boolean checkThatEachDeclarationIsOnDedicatedLine(PortClauseTree tree, List<InterfaceSignalDeclarationTree> signalDeclarations) {
        List<Integer> lines = signalDeclarations.stream().map(d -> d.identifiers().get(0).firstToken().line()).toList();
        Set linesWithMultipleDeclarations = lines.stream().filter(i -> Collections.frequency(lines, i) > 1).collect(Collectors.toSet());
        if (!linesWithMultipleDeclarations.isEmpty()) {
            this.addPreciseIssue(tree.portKeyword(), "Write each declaration on a dedicated line.", signalDeclarations.stream().filter(d -> linesWithMultipleDeclarations.contains(d.identifiers().get(0).firstToken().line())).map(HdlIssueLocation::new).toList());
            return false;
        }
        return true;
    }

    private boolean checkThatColonsAreVerticallyAligned(PortClauseTree tree, List<InterfaceSignalDeclarationTree> signalDeclarations) {
        if (this.oneSingleWhitespace) {
            int expectedColonColumn = signalDeclarations.stream().mapToInt(d -> d.identifiers().get(d.identifiers().size() - 1).lastToken().endColumn()).max().orElse(0) + 1;
            List<VhdlInternalSyntaxToken> misplacedColons = signalDeclarations.stream().map(InterfaceSignalDeclarationTree::colonToken).filter(c -> c.column() != expectedColonColumn).toList();
            if (!misplacedColons.isEmpty()) {
                this.addPreciseIssue(tree.portKeyword(), "Vertically align colons one whitespace after the longest signal name.", misplacedColons.stream().map(HdlIssueLocation::new).toList());
                return false;
            }
        } else {
            Set columns = signalDeclarations.stream().map(d -> d.colonToken().column()).collect(Collectors.toSet());
            if (columns.size() > 1) {
                this.addPreciseIssue(tree.portKeyword(), "Vertically align colons.", signalDeclarations.stream().map(d -> new HdlIssueLocation(d.colonToken())).toList());
                return false;
            }
        }
        return true;
    }

    private boolean checkThatModesAreVerticallyAligned(PortClauseTree tree, List<InterfaceSignalDeclarationTree> signalDeclarations) {
        if (this.oneSingleWhitespace) {
            List<InterfaceSignalDeclarationTree> misplacedModes = signalDeclarations.stream().filter(d -> d.mode() != null && d.mode().column() - d.colonToken().endColumn() != 1).toList();
            if (!misplacedModes.isEmpty()) {
                this.addPreciseIssue(tree.portKeyword(), "Vertically align modes one whitespace after their preceding colon.", misplacedModes.stream().map(HdlIssueLocation::new).toList());
                return false;
            }
        } else {
            Set columns = signalDeclarations.stream().filter(d -> d.mode() != null).map(d -> d.mode().column()).collect(Collectors.toSet());
            if (columns.size() > 1) {
                this.addPreciseIssue(tree.portKeyword(), "Vertically align modes.", signalDeclarations.stream().filter(d -> d.mode() != null).map(d -> new HdlIssueLocation(d.mode())).toList());
                return false;
            }
        }
        return true;
    }

    private void checkThatTypesAreVerticallyAligned(PortClauseTree tree, List<InterfaceSignalDeclarationTree> signalDeclarations) {
        if (this.oneSingleWhitespace) {
            int expectedTypeColumn = signalDeclarations.stream().filter(d -> d.mode() != null).mapToInt(d -> d.mode().lastToken().endColumn()).max().orElse(0);
            List<InterfaceSignalDeclarationTree> misplacedTypes = signalDeclarations.stream().filter(d -> d.type().firstToken().column() - expectedTypeColumn != 1).toList();
            if (!misplacedTypes.isEmpty()) {
                this.addPreciseIssue(tree.portKeyword(), "Vertically align types one whitespace after the longest mode.", misplacedTypes.stream().map(HdlIssueLocation::new).toList());
            }
        } else {
            Set columns = signalDeclarations.stream().map(d -> d.type().column()).collect(Collectors.toSet());
            if (columns.size() > 1) {
                this.addPreciseIssue(tree.portKeyword(), "Vertically align types.", signalDeclarations.stream().map(d -> new HdlIssueLocation(d.type())).toList());
            }
        }
    }
}

