/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationFunctionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationProcedureTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationTree;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL317")
public class FunctionProcedureTooManyParametersCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final int DEFAULT_MAX_NUMBER_OF_PARAMETERS = 3;
    @RuleProperty(key="max", description="The maximum allowed number of parameters.", type="INTEGER", defaultValue="3")
    public int max = 3;

    @Override
    public void visitFunctionSpecification(SubprogramSpecificationFunctionTree tree) {
        this.checkForIssue(tree);
        super.visitFunctionSpecification(tree);
    }

    @Override
    public void visitProcedureSpecification(SubprogramSpecificationProcedureTree tree) {
        this.checkForIssue(tree);
        super.visitProcedureSpecification(tree);
    }

    private void checkForIssue(SubprogramSpecificationTree tree) {
        long count;
        if (tree.parameters() != null && (count = tree.parameters().interfaces().stream().map(MultipleDeclarationTree::identifiers).mapToLong(List::size).sum()) > (long)this.max) {
            this.addPreciseIssue(tree.identifier(), String.format("Too many parameters. Actual: %d. Allowed: %d. Split this subprogram into single-responsibility subprograms.", count, this.max));
        }
    }
}

