/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.GenericClauseTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceSignalDeclarationTree;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL318")
public class GenericDefaultValueCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final boolean EXCLUDE_TOP_ENTITY_DEFAULT = false;
    @RuleProperty(key="excludeTopEntity", defaultValue="false", type="BOOLEAN", description="Set to true to not check the rule on the top entity. Set to 'false' otherwise.")
    public boolean excludeTopEntity = false;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        if (!tree.identifier().text().equalsIgnoreCase(this.context().topLevelModule()) || tree.identifier().text().equalsIgnoreCase(this.context().topLevelModule()) && !this.excludeTopEntity) {
            super.visitEntityDeclaration(tree);
        }
    }

    @Override
    public void visitGenericClause(GenericClauseTree tree) {
        for (InterfaceDeclarationTree declaration : tree.generics().interfaces()) {
            if (!(declaration instanceof InterfaceSignalDeclarationTree) || ((InterfaceSignalDeclarationTree)declaration).defaultValue() == null) continue;
            this.addPreciseIssue(((InterfaceSignalDeclarationTree)declaration).defaultValue(), "Remove this default value.");
        }
        super.visitGenericClause(tree);
    }
}

