/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ElsifStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfElsifConditionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfStatementTree;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL238")
public class IfIdenticalConditionsCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    @Override
    public void visitIfStatement(IfStatementTree tree) {
        for (Map.Entry<String, List<VhdlTree>> entry : this.getAllConditionsAsMap(tree).entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            this.addIssue(entry);
        }
        super.visitIfStatement(tree);
    }

    private Map<String, List<VhdlTree>> getAllConditionsAsMap(IfStatementTree ifStatement) {
        ArrayList<IfElsifConditionTree> conditions = new ArrayList<IfElsifConditionTree>();
        conditions.add(ifStatement.condition());
        for (ElsifStatementTree elsifStatement : ifStatement.listOfElsif()) {
            conditions.add(elsifStatement.condition());
        }
        return conditions.stream().collect(Collectors.groupingBy(this::getTrimmedCondition));
    }

    private String getTrimmedCondition(VhdlTree condition) {
        String trimmed = condition.toString().replaceAll("\\s+", "");
        while (trimmed.startsWith("(") && trimmed.endsWith(")")) {
            trimmed = trimmed.substring(1, trimmed.length() - 1);
        }
        return trimmed;
    }

    private void addIssue(Map.Entry<String, List<VhdlTree>> entry) {
        List<VhdlTree> sortedConditions = entry.getValue().stream().sorted(Comparator.comparingInt(c -> c.firstToken().line())).toList();
        ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
        for (int i = 1; i < sortedConditions.size(); ++i) {
            secondaryLocations.add(new HdlIssueLocation(sortedConditions.get(i), "Duplicated condition"));
        }
        this.addPreciseIssue(this.context().file(), sortedConditions.get(0), "Fix this duplicated condition.", secondaryLocations);
    }
}

