/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.AssociationElementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentInstantiationStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortClauseTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortMapTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL138")
public class IncompletePortMapCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final boolean DEFAULT_IN = false;
    private final Map<String, Integer> lastOutList = new HashMap<String, Integer>();
    private final Map<String, Set<String>> portMaps = new HashMap<String, Set<String>>();
    @RuleProperty(key="checkInputPorts", description="Set to 'true' to also check that input ports are mapped. Set to 'false' otherwise.", defaultValue="false")
    public boolean checkInputPorts = false;

    @Override
    public void visitComponentDeclaration(ComponentDeclarationTree tree) {
        int lastOutSignal = 0;
        String componentName = tree.identifier().text();
        List<Object> portsDecls = new ArrayList();
        PortClauseTree portClauseT = tree.portClause();
        HashSet<String> portSet = new HashSet<String>();
        int portsNb = 0;
        if (portClauseT != null) {
            portsDecls = portClauseT.ports().interfaces();
        }
        for (InterfaceDeclarationTree portsDecl : portsDecls) {
            VhdlInternalSyntaxToken mode = portsDecl.mode();
            List<IdentifierTree> portsDeclIter = portsDecl.identifiers();
            if (mode != null && (this.checkInputPorts || mode.getGrammarRuleKey() == VhdlKeyword.OUT)) {
                lastOutSignal = portsNb;
                for (IdentifierTree port : portsDeclIter) {
                    ++lastOutSignal;
                    portSet.add(port.text().toLowerCase());
                }
            }
            portsNb += portsDeclIter.size();
        }
        this.lastOutList.put(componentName, lastOutSignal);
        this.portMaps.put(componentName, portSet);
        super.visitComponentDeclaration(tree);
    }

    @Override
    public void visitComponentInstantiationStatement(ComponentInstantiationStatementTree tree) {
        String componentName = tree.instantiatedUnit().firstToken().text();
        if (this.portMaps.get(componentName) != null) {
            if (tree.portMap() != null) {
                if (tree.portMap().associationList().elements().get(0).formalPart() == null) {
                    this.checkComponentInstantiationWithPortMapWithNotNamedElement(tree.portMap(), componentName);
                } else {
                    this.checkComponentInstantiationWithPortMapWithNamedElement(tree.portMap(), new HashSet<String>((Collection)this.portMaps.get(componentName)));
                }
            } else {
                this.checkComponentInstantiationWithNoPortMap(tree, this.portMaps.get(componentName));
            }
        }
        super.visitComponentInstantiationStatement(tree);
    }

    private void checkComponentInstantiationWithNoPortMap(ComponentInstantiationStatementTree tree, Set<String> componentDeclarationPortNames) {
        if (!componentDeclarationPortNames.isEmpty()) {
            this.addPreciseIssue(tree.instantiatedUnit(), "Map all the missing " + this.portTypes() + " ports.");
        }
    }

    private void checkComponentInstantiationWithPortMapWithNamedElement(PortMapTree portMap, Set<String> componentDeclarationPortNames) {
        for (AssociationElementTree componentInstantiationPort : portMap.associationList().elements()) {
            String componentInstantiationPortName = componentInstantiationPort.formalPart().firstToken().text().toLowerCase();
            componentDeclarationPortNames.remove(componentInstantiationPortName);
        }
        if (!componentDeclarationPortNames.isEmpty()) {
            this.addPreciseIssue(portMap, "Map all the missing " + this.portTypes() + " ports: " + componentDeclarationPortNames.stream().sorted().collect(Collectors.joining(", ")) + ".");
        }
    }

    private void checkComponentInstantiationWithPortMapWithNotNamedElement(PortMapTree portMap, String componentName) {
        if (portMap.associationList().elements().size() < this.lastOutList.get(componentName)) {
            this.addPreciseIssue(portMap, "Map all the missing " + this.portTypes() + " ports.");
        }
    }

    private String portTypes() {
        if (this.checkInputPorts) {
            return "input and output";
        }
        return "output";
    }
}

