/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.AssociationElementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortMapTree;
import org.sonar.check.Rule;

@Rule(key="VHDL188")
public class InstantiationByNameCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    @Override
    public void visitPortMap(PortMapTree tree) {
        if (this.hasInstantiationByPosition(tree)) {
            this.addPreciseIssue(tree, "Instantiate by name instead of instantiating by position.");
        }
        super.visitPortMap(tree);
    }

    private boolean hasInstantiationByPosition(PortMapTree tree) {
        for (AssociationElementTree element : tree.associationList().elements()) {
            if (element.formalPart() != null) continue;
            return true;
        }
        return false;
    }
}

