/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.utils.LintyException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tika.langdetect.optimaize.OptimaizeLangDetector;
import org.apache.tika.language.detect.LanguageDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL225")
public class LanguageCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final String DEFAULT_LANGUAGE = "ENGLISH";
    private static final List<String> SUPPORTED_LANGUAGES = List.of("ENGLISH", "FRENCH", "GERMAN", "ITALIAN", "PORTUGUESE", "SPANISH");
    private static final Map<String, String> LANGUAGE_MATCH = Map.of("ENGLISH", "en", "FRENCH", "fr", "GERMAN", "de", "ITALIAN", "it", "PORTUGUESE", "pt", "SPANISH", "es");
    @RuleProperty(key="language", description="Possible values: ENGLISH, FRENCH, GERMAN, ITALIAN, PORTUGUESE, SPANISH", defaultValue="ENGLISH")
    public String language = "ENGLISH";

    @Override
    public void visitInternalSyntaxToken(VhdlInternalSyntaxToken token) {
        LanguageDetector detector;
        LanguageResult result;
        String actualComment;
        if (!token.trivias().isEmpty() && this.shouldCommentBeChecked(actualComment = this.actualComment(token)) && !(result = (detector = new OptimaizeLangDetector().loadModels()).detect(actualComment)).getLanguage().equals(LANGUAGE_MATCH.get(this.language.toUpperCase()))) {
            this.addPreciseIssue(token.trivias().get(0), "Write this comment in " + this.language.toLowerCase() + " or remove this commented-out code.");
        }
        super.visitInternalSyntaxToken(token);
    }

    @Override
    public void validateCheckParameters() {
        if (!SUPPORTED_LANGUAGES.contains(this.language.toUpperCase())) {
            throw new LintyException(LanguageCheck.paramsErrorMessage(this.getClass(), "language parameter \"" + this.language + "\" is not a valid language. Possible values are: " + String.join((CharSequence)", ", SUPPORTED_LANGUAGES) + "."));
        }
    }

    private String actualComment(VhdlInternalSyntaxToken token) {
        return token.trivias().stream().map(SyntaxTrivia::actualText).map(t -> t.replace("-", "")).map(t -> t.replace("*", "")).collect(Collectors.joining(" "));
    }

    private boolean shouldCommentBeChecked(String comment) {
        return this.countWords(comment) > 10;
    }

    private int countWords(String input) {
        if (input.isEmpty()) {
            return 0;
        }
        String[] words = input.split("\\s+");
        return words.length;
    }
}

