/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.LibraryClauseTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.UseClauseTree;
import com.lintyservices.utils.LintyException;
import java.util.Arrays;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL302")
public class LibraryCaseCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final String LOWERCASE = "lowercase";
    private static final String UPPERCASE = "uppercase";
    @RuleProperty(key="case", description="Case. Either 'lowercase' or 'uppercase'.", defaultValue="lowercase")
    public String libraryCase = "lowercase";

    @Override
    public void visitUseClause(UseClauseTree tree) {
        for (SelectedNameTree library : tree.libraries().list().elements()) {
            String expected;
            String string = expected = UPPERCASE.equals(this.libraryCase) ? library.toString().toUpperCase() : library.toString().toLowerCase();
            if (library.toString().equals(expected)) continue;
            this.addPreciseIssue(library, "Update this library to only use " + this.libraryCase + " characters.");
        }
        super.visitUseClause(tree);
    }

    @Override
    public void visitLibraryClause(LibraryClauseTree tree) {
        for (IdentifierTree identifier : tree.identifiers()) {
            String expected;
            String string = expected = UPPERCASE.equals(this.libraryCase) ? identifier.text().toUpperCase() : identifier.text().toLowerCase();
            if (identifier.text().equals(expected)) continue;
            this.addPreciseIssue(identifier, "Update this library to only use " + this.libraryCase + " characters.");
        }
        super.visitLibraryClause(tree);
    }

    @Override
    public void validateCheckParameters() {
        if (!Arrays.asList(LOWERCASE, UPPERCASE).contains(this.libraryCase)) {
            throw new LintyException(LibraryCaseCheck.paramsErrorMessage(this.getClass(), "'case' parameter is not valid.\nActual: '" + this.libraryCase + "'\nExpected: 'lowercase' or 'uppercase'"));
        }
    }
}

