/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SubtypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.Node;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.SubtypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.ArrayTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstrainedArrayDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.UnconstrainedArrayDefinitionTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL182")
public class MaxArrayDimensionsCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck,
TypeTreeFileAwareVisitor,
SubtypeTreeFileAwareVisitor {
    private static final int MAX_DIMENSION = 2;
    private Set<TypeTreeFile> arrayTypes = new HashSet<TypeTreeFile>();
    private Set<SubtypeTreeFile> subtypes = new HashSet<SubtypeTreeFile>();
    @RuleProperty(key="maxDimensions", defaultValue="2", description="Maximum allowed number of dimensions")
    public int maxDimensions = 2;

    @Override
    public void setTypes(Set<TypeTreeFile> types) {
        this.arrayTypes = types.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof ArrayTypeDefinitionTree).collect(Collectors.toSet());
    }

    @Override
    public void setSubtypes(Set<SubtypeTreeFile> subtypes) {
        this.subtypes = subtypes;
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitConstrainedArrayDefinition(ConstrainedArrayDefinitionTree tree) {
        this.checkForIssue(tree);
        super.visitConstrainedArrayDefinition(tree);
    }

    @Override
    public void visitUnconstrainedArrayDefinition(UnconstrainedArrayDefinitionTree tree) {
        this.checkForIssue(tree);
        super.visitUnconstrainedArrayDefinition(tree);
    }

    private void checkForIssue(VhdlTree arrayTree) {
        Node<GenericTreeFile<VhdlTree>> node = new Node<GenericTreeFile<VhdlTree>>(new GenericTreeFile<VhdlTree>(arrayTree, this.context().file()));
        this.buildTree(node, this.arrayTypes, this.subtypes);
        int dimensions = ((ArrayTypeDefinitionTree)node.getData().tree()).dimensions();
        ArrayList<HdlIssueLocation> flow = new ArrayList<HdlIssueLocation>();
        for (Node<GenericTreeFile<VhdlTree>> currentNode : node.getAllChildren()) {
            int additionalDimensions = 0;
            if (((VhdlTree)currentNode.getData().tree()).is(VhdlTree.Kind.FULL_TYPE_DECLARATION)) {
                additionalDimensions = ((ArrayTypeDefinitionTree)((FullTypeDeclarationTree)currentNode.getData().tree()).typeDefinition()).dimensions();
            }
            flow.add(new HdlIssueLocation(currentNode.getData().file(), (Tree)currentNode.getData().tree(), "Related type"));
            dimensions += additionalDimensions;
        }
        if (dimensions > this.maxDimensions) {
            String message = "The number of dimensions (" + dimensions + ") is greater the maximum allowed number of dimensions (" + this.maxDimensions + ").";
            VhdlTree tree = (VhdlTree)node.getData().tree();
            if (flow.isEmpty()) {
                this.addPreciseIssue(tree, message);
            } else {
                Collections.reverse(flow);
                this.addPreciseIssueWithFlows(tree, message, List.of(flow));
            }
        }
    }

    private void buildTree(Node<GenericTreeFile<VhdlTree>> node, Set<TypeTreeFile> arrayTypes, Set<SubtypeTreeFile> subtypes) {
        NameTree childNameTree;
        String type = ((VhdlTree)node.getData().tree()).is(VhdlTree.Kind.FULL_TYPE_DECLARATION) ? ((ArrayTypeDefinitionTree)((FullTypeDeclarationTree)node.getData().tree()).typeDefinition()).subtypeIndication().typeName().firstToken().text() : (((VhdlTree)node.getData().tree()).is(VhdlTree.Kind.SUBTYPE_DECLARATION) ? ((SubtypeDeclarationTree)node.getData().tree()).subtypeIndication().typeName().firstToken().text() : ((ArrayTypeDefinitionTree)node.getData().tree()).subtypeIndication().typeName().firstToken().text());
        TypeTreeFile relatedArrayTypeTreeFile = arrayTypes.stream().filter(tf -> ((FullTypeDeclarationTree)tf.tree()).identifier().text().equalsIgnoreCase(type)).findFirst().orElse(null);
        SubtypeTreeFile relatedSubtypeTreeFile = subtypes.stream().filter(tf -> ((SubtypeDeclarationTree)tf.tree()).identifier().text().equalsIgnoreCase(type)).findFirst().orElse(null);
        if (relatedArrayTypeTreeFile != null) {
            Node<GenericTreeFile<VhdlTree>> child = new Node<GenericTreeFile<VhdlTree>>(new GenericTreeFile<VhdlTree>((VhdlTree)relatedArrayTypeTreeFile.tree(), relatedArrayTypeTreeFile.file()));
            node.addChild(child);
            this.buildTree(child, arrayTypes, subtypes);
        } else if (relatedSubtypeTreeFile != null && (childNameTree = ((SubtypeDeclarationTree)relatedSubtypeTreeFile.tree()).subtypeIndication().typeName()) != null) {
            Node<GenericTreeFile<VhdlTree>> child = new Node<GenericTreeFile<VhdlTree>>(new GenericTreeFile<VhdlTree>((VhdlTree)relatedSubtypeTreeFile.tree(), relatedSubtypeTreeFile.file()));
            node.addChild(child);
            this.buildTree(child, arrayTypes, subtypes);
        }
    }
}

