/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureDeclarativePartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConfigurationDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarativePartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL165")
public class MisplacedUseClauseCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitPackageDeclaration(PackageDeclarationTree tree) {
        this.checkForIssues(tree.declarativeItems());
        super.visitPackageDeclaration(tree);
    }

    @Override
    public void visitArchitectureDeclarativePart(ArchitectureDeclarativePartTree tree) {
        this.checkForIssues(tree.blockDeclarativeItems());
        super.visitArchitectureDeclarativePart(tree);
    }

    @Override
    public void visitEntityDeclarativePart(EntityDeclarativePartTree tree) {
        this.checkForIssues(tree.items());
        super.visitEntityDeclarativePart(tree);
    }

    @Override
    public void visitConfigurationDeclaration(ConfigurationDeclarationTree tree) {
        this.checkForIssues(tree.declarativePart().stream().map(t -> {
            if (t.useClause() != null) {
                return t.useClause();
            }
            if (t.attributeSpecification() != null) {
                return t.attributeSpecification();
            }
            if (t.groupDeclaration() != null) {
                return t.groupDeclaration();
            }
            return null;
        }).collect(Collectors.toList()));
        super.visitConfigurationDeclaration(tree);
    }

    private void checkForIssues(List<? extends VhdlTree> declarativeItems) {
        boolean nonUseClauseFound = false;
        for (VhdlTree vhdlTree : declarativeItems) {
            if (vhdlTree.is(VhdlTree.Kind.USE_CLAUSE)) {
                if (!nonUseClauseFound) continue;
                this.addPreciseIssue(vhdlTree, "Move the \"use\" clause to the top of the declarative part.");
                continue;
            }
            nonUseClauseFound = true;
        }
    }
}

