/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.AliasDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SingleDeclarationTree;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL126")
public class MultipleDeclarationsSameLineCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private boolean varSameDeclaration;
    private int lastVarLine;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.lastVarLine = -1;
        this.varSameDeclaration = false;
        super.visitDesignFile(tree);
    }

    @Override
    public void visitDeclaration(DeclarationTree tree) {
        int line = -1;
        List<IdentifierTree> ids = null;
        switch (tree.kind()) {
            case CONSTANT_DECLARATION: 
            case SIGNAL_DECLARATION: 
            case INTERFACE_VARIABLE_DECLARATION: 
            case ELEMENT_DECLARATION: 
            case INTERFACE_CONSTANT_DECLARATION: {
                ids = ((MultipleDeclarationTree)tree).identifiers();
                break;
            }
            case INCOMPLETE_TYPE_DECLARATION: 
            case FULL_TYPE_DECLARATION: 
            case ATTRIBUTE_DECLARATION: 
            case SUBTYPE_DECLARATION: 
            case SECONDARY_UNIT_DECLARATION: {
                ids = Collections.singletonList(((SingleDeclarationTree)tree).identifier());
                break;
            }
            case ALIAS_DECLARATION: {
                line = ((AliasDeclarationTree)tree).aliasDesignator().line();
                break;
            }
        }
        if (ids != null) {
            for (IdentifierTree id : ids) {
                line = id.identifier().line();
                if (this.varSameDeclaration || this.lastVarLine == line) {
                    this.addIssue(id);
                }
                this.varSameDeclaration = ",".equals(tree.lastToken().text());
                this.lastVarLine = line;
            }
        } else if (line != -1) {
            if (this.varSameDeclaration || this.lastVarLine == line) {
                this.addIssue(tree);
            }
            this.varSameDeclaration = ",".equals(tree.lastToken().text());
            this.lastVarLine = line;
        }
    }

    private void addIssue(VhdlTree tree) {
        this.addPreciseIssue(tree, "Move this declaration to a dedicated line.");
    }
}

