/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceSignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortClauseTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortMapTree;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL137")
public class MultiplePortsOnOneLineCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private boolean varSameDeclaration;
    private int lastVarLine;
    private int line;
    private List<? extends VhdlTree> ids;
    private boolean clause;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.lastVarLine = -1;
        this.varSameDeclaration = false;
        super.visitDesignFile(tree);
    }

    @Override
    public void visitPortClause(PortClauseTree tree) {
        this.init();
        this.ids = tree.ports().interfaces().stream().filter(o -> o.is(VhdlTree.Kind.INTERFACE_SIGNAL_DECLARATION)).collect(Collectors.toList());
        this.clause = true;
        this.checkPortsDeclarations(tree);
        super.visitPortClause(tree);
    }

    @Override
    public void visitPortMap(PortMapTree tree) {
        this.init();
        this.ids = tree.associationList().elements();
        this.checkPortsDeclarations(tree);
        super.visitPortMap(tree);
    }

    private void init() {
        this.line = -1;
        this.ids = null;
        this.clause = false;
    }

    private void checkPortsDeclarations(VhdlTree tree) {
        for (VhdlTree vhdlTree : this.ids) {
            List<VhdlTree> portsDeclIter = this.clause ? ((InterfaceSignalDeclarationTree)vhdlTree).identifiers() : Collections.singletonList(vhdlTree);
            for (VhdlTree port : portsDeclIter) {
                this.line = port.firstToken().line();
                if (this.varSameDeclaration || this.lastVarLine == this.line) {
                    this.addPreciseIssue(port, "Put the port declarations on separate lines.");
                }
                this.varSameDeclaration = ",".equals(tree.lastToken().text());
                this.lastVarLine = this.line;
            }
        }
    }
}

