/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.AssertionStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.BlockStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseGenerateStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentInstantiationStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConcurrentAssertionStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConcurrentSignalAssignmentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ElsifStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ExitStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ForGenerateStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.LoopStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NextStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NullStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcedureCallStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ReportStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ReturnStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SimpleForceSignalAssignmentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SimpleReleaseSignalAssignmentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SimpleWaveformSignalAssignmentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VariableAssignmentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.WaitStatementTree;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VHDL161")
public class MultipleStatementsOnOneLineCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private Set<Integer> lines;
    private Set<Integer> errorLines;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.lines = new HashSet<Integer>();
        this.errorLines = new HashSet<Integer>();
        super.visitDesignFile(tree);
    }

    @Override
    public void visitAssertionStatement(AssertionStatementTree tree) {
        this.visitStatement(tree);
        super.visitAssertionStatement(tree);
    }

    @Override
    public void visitBlockStatement(BlockStatementTree tree) {
        this.visitStatement(tree);
        super.visitBlockStatement(tree);
    }

    @Override
    public void visitCaseStatement(CaseStatementTree tree) {
        this.visitStatement(tree);
        super.visitCaseStatement(tree);
    }

    @Override
    public void visitComponentInstantiationStatement(ComponentInstantiationStatementTree tree) {
        this.visitStatement(tree);
        super.visitComponentInstantiationStatement(tree);
    }

    @Override
    public void visitConcurrentAssertionStatement(ConcurrentAssertionStatementTree tree) {
        this.visitStatement(tree);
        super.visitConcurrentAssertionStatement(tree);
    }

    @Override
    public void visitConcurrentSignalAssignmentStatement(ConcurrentSignalAssignmentStatementTree tree) {
        this.visitStatement(tree);
        super.visitConcurrentSignalAssignmentStatement(tree);
    }

    @Override
    public void visitElsifStatement(ElsifStatementTree tree) {
        this.visitStatement(tree);
        super.visitElsifStatement(tree);
    }

    @Override
    public void visitExitStatement(ExitStatementTree tree) {
        this.visitStatement(tree);
        super.visitExitStatement(tree);
    }

    @Override
    public void visitForGenerateStatement(ForGenerateStatementTree tree) {
        this.visitStatement(tree);
        super.visitForGenerateStatement(tree);
    }

    @Override
    public void visitCaseGenerateStatement(CaseGenerateStatementTree tree) {
        this.visitStatement(tree);
        super.visitCaseGenerateStatement(tree);
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.visitStatement(tree);
        super.visitIfStatement(tree);
    }

    @Override
    public void visitForStatement(LoopStatementTree tree) {
        this.visitStatement(tree);
        super.visitForStatement(tree);
    }

    @Override
    public void visitWhileStatement(LoopStatementTree tree) {
        this.visitStatement(tree);
        super.visitWhileStatement(tree);
    }

    @Override
    public void visitNextStatement(NextStatementTree tree) {
        this.visitStatement(tree);
        super.visitNextStatement(tree);
    }

    @Override
    public void visitNullStatement(NullStatementTree tree) {
        this.visitStatement(tree);
        super.visitNullStatement(tree);
    }

    @Override
    public void visitProcedureCallStatement(ProcedureCallStatementTree tree) {
        this.visitStatement(tree);
        super.visitProcedureCallStatement(tree);
    }

    @Override
    public void visitProcessStatement(ProcessStatementTree tree) {
        this.visitStatement(tree);
        super.visitProcessStatement(tree);
    }

    @Override
    public void visitReportStatement(ReportStatementTree tree) {
        this.visitStatement(tree);
        super.visitReportStatement(tree);
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.visitStatement(tree);
        super.visitReturnStatement(tree);
    }

    @Override
    public void visitSimpleWaveformSignalAssignmentStatement(SimpleWaveformSignalAssignmentStatementTree tree) {
        this.visitStatement(tree);
        super.visitSimpleWaveformSignalAssignmentStatement(tree);
    }

    @Override
    public void visitSimpleReleaseSignalAssignmentStatement(SimpleReleaseSignalAssignmentStatementTree tree) {
        this.visitStatement(tree);
        super.visitSimpleReleaseSignalAssignmentStatement(tree);
    }

    @Override
    public void visitSimpleForceSignalAssignmentStatement(SimpleForceSignalAssignmentStatementTree tree) {
        this.visitStatement(tree);
        super.visitSimpleForceSignalAssignmentStatement(tree);
    }

    @Override
    public void visitVariableAssignmentStatement(VariableAssignmentStatementTree tree) {
        this.visitStatement(tree);
        super.visitVariableAssignmentStatement(tree);
    }

    @Override
    public void visitWaitStatement(WaitStatementTree tree) {
        this.visitStatement(tree);
        super.visitWaitStatement(tree);
    }

    private void visitStatement(VhdlTree tree) {
        int startLine = tree.firstToken().line();
        int endLine = tree.lastToken().line();
        if (!this.lines.add(startLine) && this.errorLines.add(startLine)) {
            this.addLineIssue(startLine, "Put the statements on separate lines.");
        }
        if (startLine != endLine && !tree.is(VhdlTree.Kind.ELSIF_STATEMENT) && !this.lines.add(endLine) && this.errorLines.add(endLine)) {
            this.addLineIssue(endLine, "Put the statements on separate lines.");
        }
    }
}

